package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.action.extended.community;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * container traffic-action-extended-community {
 *   leaf sample {
 *     type boolean;
 *     default false;
 *   }
 *   leaf terminal-action {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/traffic-action-extended-community/traffic-action-extended-community</i>
 *
 * <p>To create instances of this class use {@link TrafficActionExtendedCommunityBuilder}.
 * @see TrafficActionExtendedCommunityBuilder
 *
 */
public interface TrafficActionExtendedCommunity
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.TrafficActionExtendedCommunity>,
    Augmentable<TrafficActionExtendedCommunity>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("traffic-action-extended-community");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.action.extended.community.TrafficActionExtendedCommunity> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.action.extended.community.TrafficActionExtendedCommunity.class;
    }
    
    /**
     * @return <code>java.lang.Boolean</code> <code>sample</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isSample();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>terminalAction</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isTerminalAction();

}

