package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.rate.extended.community;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>bgp-flowspec</b>
 * <pre>
 * container traffic-rate-extended-community {
 *   leaf informative-as {
 *     type bgp-t:short-as-number;
 *   }
 *   leaf local-administrator {
 *     type netc:bandwidth;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>bgp-flowspec/traffic-rate-extended-community/traffic-rate-extended-community</i>
 *
 * <p>To create instances of this class use {@link TrafficRateExtendedCommunityBuilder}.
 * @see TrafficRateExtendedCommunityBuilder
 *
 */
public interface TrafficRateExtendedCommunity
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.TrafficRateExtendedCommunity>,
    Augmentable<TrafficRateExtendedCommunity>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("traffic-rate-extended-community");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.rate.extended.community.TrafficRateExtendedCommunity> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.rate.extended.community.TrafficRateExtendedCommunity.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ShortAsNumber</code> <code>informativeAs</code>, or <code>null</code> if not present
     */
    @Nullable ShortAsNumber getInformativeAs();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth</code> <code>localAdministrator</code>, or <code>null</code> if not present
     */
    @Nullable Bandwidth getLocalAdministrator();

}

