package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.update.attributes.extended.communities.extended.community;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.as4.extended.community.RedirectAs4;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RedirectAs4ExtendedCommunityCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RedirectAs4ExtendedCommunityCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RedirectAs4ExtendedCommunityCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RedirectAs4ExtendedCommunityCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RedirectAs4ExtendedCommunityCaseBuilder
 * @see Builder
 *
 */
public class RedirectAs4ExtendedCommunityCaseBuilder implements Builder<RedirectAs4ExtendedCommunityCase> {

    private RedirectAs4 _redirectAs4;


    Map<Class<? extends Augmentation<RedirectAs4ExtendedCommunityCase>>, Augmentation<RedirectAs4ExtendedCommunityCase>> augmentation = Collections.emptyMap();

    public RedirectAs4ExtendedCommunityCaseBuilder() {
    }
    public RedirectAs4ExtendedCommunityCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectAs4ExtendedCommunity arg) {
        this._redirectAs4 = arg.getRedirectAs4();
    }

    public RedirectAs4ExtendedCommunityCaseBuilder(RedirectAs4ExtendedCommunityCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RedirectAs4ExtendedCommunityCase>>, Augmentation<RedirectAs4ExtendedCommunityCase>> aug =((AugmentationHolder<RedirectAs4ExtendedCommunityCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._redirectAs4 = base.getRedirectAs4();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectAs4ExtendedCommunity</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectAs4ExtendedCommunity) {
            this._redirectAs4 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectAs4ExtendedCommunity)arg).getRedirectAs4();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectAs4ExtendedCommunity]");
    }

    public RedirectAs4 getRedirectAs4() {
        return _redirectAs4;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RedirectAs4ExtendedCommunityCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RedirectAs4ExtendedCommunityCaseBuilder setRedirectAs4(final RedirectAs4 value) {
        this._redirectAs4 = value;
        return this;
    }
    
    public RedirectAs4ExtendedCommunityCaseBuilder addAugmentation(Class<? extends Augmentation<RedirectAs4ExtendedCommunityCase>> augmentationType, Augmentation<RedirectAs4ExtendedCommunityCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RedirectAs4ExtendedCommunityCaseBuilder removeAugmentation(Class<? extends Augmentation<RedirectAs4ExtendedCommunityCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RedirectAs4ExtendedCommunityCase build() {
        return new RedirectAs4ExtendedCommunityCaseImpl(this);
    }

    private static final class RedirectAs4ExtendedCommunityCaseImpl
        extends AbstractAugmentable<RedirectAs4ExtendedCommunityCase>
        implements RedirectAs4ExtendedCommunityCase {
    
        private final RedirectAs4 _redirectAs4;
    
        RedirectAs4ExtendedCommunityCaseImpl(RedirectAs4ExtendedCommunityCaseBuilder base) {
            super(base.augmentation);
            this._redirectAs4 = base.getRedirectAs4();
        }
    
        @Override
        public RedirectAs4 getRedirectAs4() {
            return _redirectAs4;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_redirectAs4);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RedirectAs4ExtendedCommunityCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            RedirectAs4ExtendedCommunityCase other = (RedirectAs4ExtendedCommunityCase)obj;
            if (!Objects.equals(_redirectAs4, other.getRedirectAs4())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RedirectAs4ExtendedCommunityCaseImpl otherImpl = (RedirectAs4ExtendedCommunityCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RedirectAs4ExtendedCommunityCase>>, Augmentation<RedirectAs4ExtendedCommunityCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RedirectAs4ExtendedCommunityCase");
            CodeHelpers.appendValue(helper, "_redirectAs4", _redirectAs4);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
