package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.update.attributes.extended.communities.extended.community;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.redirect.ipv6.extended.community.RedirectIpv6;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RedirectIpv6ExtendedCommunityCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RedirectIpv6ExtendedCommunityCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RedirectIpv6ExtendedCommunityCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RedirectIpv6ExtendedCommunityCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RedirectIpv6ExtendedCommunityCaseBuilder
 * @see Builder
 *
 */
public class RedirectIpv6ExtendedCommunityCaseBuilder implements Builder<RedirectIpv6ExtendedCommunityCase> {

    private RedirectIpv6 _redirectIpv6;


    Map<Class<? extends Augmentation<RedirectIpv6ExtendedCommunityCase>>, Augmentation<RedirectIpv6ExtendedCommunityCase>> augmentation = Collections.emptyMap();

    public RedirectIpv6ExtendedCommunityCaseBuilder() {
    }
    public RedirectIpv6ExtendedCommunityCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpv6ExtendedCommunity arg) {
        this._redirectIpv6 = arg.getRedirectIpv6();
    }

    public RedirectIpv6ExtendedCommunityCaseBuilder(RedirectIpv6ExtendedCommunityCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<RedirectIpv6ExtendedCommunityCase>>, Augmentation<RedirectIpv6ExtendedCommunityCase>> aug =((AugmentationHolder<RedirectIpv6ExtendedCommunityCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._redirectIpv6 = base.getRedirectIpv6();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpv6ExtendedCommunity</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpv6ExtendedCommunity) {
            this._redirectIpv6 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpv6ExtendedCommunity)arg).getRedirectIpv6();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.RedirectIpv6ExtendedCommunity]");
    }

    public RedirectIpv6 getRedirectIpv6() {
        return _redirectIpv6;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RedirectIpv6ExtendedCommunityCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public RedirectIpv6ExtendedCommunityCaseBuilder setRedirectIpv6(final RedirectIpv6 value) {
        this._redirectIpv6 = value;
        return this;
    }
    
    public RedirectIpv6ExtendedCommunityCaseBuilder addAugmentation(Class<? extends Augmentation<RedirectIpv6ExtendedCommunityCase>> augmentationType, Augmentation<RedirectIpv6ExtendedCommunityCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RedirectIpv6ExtendedCommunityCaseBuilder removeAugmentation(Class<? extends Augmentation<RedirectIpv6ExtendedCommunityCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RedirectIpv6ExtendedCommunityCase build() {
        return new RedirectIpv6ExtendedCommunityCaseImpl(this);
    }

    private static final class RedirectIpv6ExtendedCommunityCaseImpl
        extends AbstractAugmentable<RedirectIpv6ExtendedCommunityCase>
        implements RedirectIpv6ExtendedCommunityCase {
    
        private final RedirectIpv6 _redirectIpv6;
    
        RedirectIpv6ExtendedCommunityCaseImpl(RedirectIpv6ExtendedCommunityCaseBuilder base) {
            super(base.augmentation);
            this._redirectIpv6 = base.getRedirectIpv6();
        }
    
        @Override
        public RedirectIpv6 getRedirectIpv6() {
            return _redirectIpv6;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_redirectIpv6);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RedirectIpv6ExtendedCommunityCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            RedirectIpv6ExtendedCommunityCase other = (RedirectIpv6ExtendedCommunityCase)obj;
            if (!Objects.equals(_redirectIpv6, other.getRedirectIpv6())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RedirectIpv6ExtendedCommunityCaseImpl otherImpl = (RedirectIpv6ExtendedCommunityCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<RedirectIpv6ExtendedCommunityCase>>, Augmentation<RedirectIpv6ExtendedCommunityCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("RedirectIpv6ExtendedCommunityCase");
            CodeHelpers.appendValue(helper, "_redirectIpv6", _redirectIpv6);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
