package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.update.attributes.extended.communities.extended.community;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.traffic.marking.extended.community.TrafficMarkingExtendedCommunity;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TrafficMarkingExtendedCommunityCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TrafficMarkingExtendedCommunityCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new TrafficMarkingExtendedCommunityCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TrafficMarkingExtendedCommunityCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TrafficMarkingExtendedCommunityCaseBuilder
 * @see Builder
 *
 */
public class TrafficMarkingExtendedCommunityCaseBuilder implements Builder<TrafficMarkingExtendedCommunityCase> {

    private TrafficMarkingExtendedCommunity _trafficMarkingExtendedCommunity;


    Map<Class<? extends Augmentation<TrafficMarkingExtendedCommunityCase>>, Augmentation<TrafficMarkingExtendedCommunityCase>> augmentation = Collections.emptyMap();

    public TrafficMarkingExtendedCommunityCaseBuilder() {
    }
    public TrafficMarkingExtendedCommunityCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.TrafficMarkingExtendedCommunity arg) {
        this._trafficMarkingExtendedCommunity = arg.getTrafficMarkingExtendedCommunity();
    }

    public TrafficMarkingExtendedCommunityCaseBuilder(TrafficMarkingExtendedCommunityCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<TrafficMarkingExtendedCommunityCase>>, Augmentation<TrafficMarkingExtendedCommunityCase>> aug =((AugmentationHolder<TrafficMarkingExtendedCommunityCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._trafficMarkingExtendedCommunity = base.getTrafficMarkingExtendedCommunity();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.TrafficMarkingExtendedCommunity</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.TrafficMarkingExtendedCommunity) {
            this._trafficMarkingExtendedCommunity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.TrafficMarkingExtendedCommunity)arg).getTrafficMarkingExtendedCommunity();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.TrafficMarkingExtendedCommunity]");
    }

    public TrafficMarkingExtendedCommunity getTrafficMarkingExtendedCommunity() {
        return _trafficMarkingExtendedCommunity;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<TrafficMarkingExtendedCommunityCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public TrafficMarkingExtendedCommunityCaseBuilder setTrafficMarkingExtendedCommunity(final TrafficMarkingExtendedCommunity value) {
        this._trafficMarkingExtendedCommunity = value;
        return this;
    }
    
    public TrafficMarkingExtendedCommunityCaseBuilder addAugmentation(Class<? extends Augmentation<TrafficMarkingExtendedCommunityCase>> augmentationType, Augmentation<TrafficMarkingExtendedCommunityCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public TrafficMarkingExtendedCommunityCaseBuilder removeAugmentation(Class<? extends Augmentation<TrafficMarkingExtendedCommunityCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public TrafficMarkingExtendedCommunityCase build() {
        return new TrafficMarkingExtendedCommunityCaseImpl(this);
    }

    private static final class TrafficMarkingExtendedCommunityCaseImpl
        extends AbstractAugmentable<TrafficMarkingExtendedCommunityCase>
        implements TrafficMarkingExtendedCommunityCase {
    
        private final TrafficMarkingExtendedCommunity _trafficMarkingExtendedCommunity;
    
        TrafficMarkingExtendedCommunityCaseImpl(TrafficMarkingExtendedCommunityCaseBuilder base) {
            super(base.augmentation);
            this._trafficMarkingExtendedCommunity = base.getTrafficMarkingExtendedCommunity();
        }
    
        @Override
        public TrafficMarkingExtendedCommunity getTrafficMarkingExtendedCommunity() {
            return _trafficMarkingExtendedCommunity;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_trafficMarkingExtendedCommunity);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TrafficMarkingExtendedCommunityCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            TrafficMarkingExtendedCommunityCase other = (TrafficMarkingExtendedCommunityCase)obj;
            if (!Objects.equals(_trafficMarkingExtendedCommunity, other.getTrafficMarkingExtendedCommunity())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TrafficMarkingExtendedCommunityCaseImpl otherImpl = (TrafficMarkingExtendedCommunityCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<TrafficMarkingExtendedCommunityCase>>, Augmentation<TrafficMarkingExtendedCommunityCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("TrafficMarkingExtendedCommunityCase");
            CodeHelpers.appendValue(helper, "_trafficMarkingExtendedCommunity", _trafficMarkingExtendedCommunity);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
