package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.update.attributes.mp.reach.nlri.advertized.routes.destination.type;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.destination.ipv6.DestinationFlowspecIpv6;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DestinationFlowspecIpv6CaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DestinationFlowspecIpv6CaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DestinationFlowspecIpv6CaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DestinationFlowspecIpv6CaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DestinationFlowspecIpv6CaseBuilder
 * @see Builder
 *
 */
public class DestinationFlowspecIpv6CaseBuilder implements Builder<DestinationFlowspecIpv6Case> {

    private DestinationFlowspecIpv6 _destinationFlowspecIpv6;


    Map<Class<? extends Augmentation<DestinationFlowspecIpv6Case>>, Augmentation<DestinationFlowspecIpv6Case>> augmentation = Collections.emptyMap();

    public DestinationFlowspecIpv6CaseBuilder() {
    }
    public DestinationFlowspecIpv6CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationIpv6 arg) {
        this._destinationFlowspecIpv6 = arg.getDestinationFlowspecIpv6();
    }

    public DestinationFlowspecIpv6CaseBuilder(DestinationFlowspecIpv6Case base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DestinationFlowspecIpv6Case>>, Augmentation<DestinationFlowspecIpv6Case>> aug =((AugmentationHolder<DestinationFlowspecIpv6Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._destinationFlowspecIpv6 = base.getDestinationFlowspecIpv6();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationIpv6</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationIpv6) {
            this._destinationFlowspecIpv6 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationIpv6)arg).getDestinationFlowspecIpv6();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecDestinationIpv6]");
    }

    public DestinationFlowspecIpv6 getDestinationFlowspecIpv6() {
        return _destinationFlowspecIpv6;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DestinationFlowspecIpv6Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DestinationFlowspecIpv6CaseBuilder setDestinationFlowspecIpv6(final DestinationFlowspecIpv6 value) {
        this._destinationFlowspecIpv6 = value;
        return this;
    }
    
    public DestinationFlowspecIpv6CaseBuilder addAugmentation(Class<? extends Augmentation<DestinationFlowspecIpv6Case>> augmentationType, Augmentation<DestinationFlowspecIpv6Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DestinationFlowspecIpv6CaseBuilder removeAugmentation(Class<? extends Augmentation<DestinationFlowspecIpv6Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DestinationFlowspecIpv6Case build() {
        return new DestinationFlowspecIpv6CaseImpl(this);
    }

    private static final class DestinationFlowspecIpv6CaseImpl
        extends AbstractAugmentable<DestinationFlowspecIpv6Case>
        implements DestinationFlowspecIpv6Case {
    
        private final DestinationFlowspecIpv6 _destinationFlowspecIpv6;
    
        DestinationFlowspecIpv6CaseImpl(DestinationFlowspecIpv6CaseBuilder base) {
            super(base.augmentation);
            this._destinationFlowspecIpv6 = base.getDestinationFlowspecIpv6();
        }
    
        @Override
        public DestinationFlowspecIpv6 getDestinationFlowspecIpv6() {
            return _destinationFlowspecIpv6;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_destinationFlowspecIpv6);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DestinationFlowspecIpv6Case.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DestinationFlowspecIpv6Case other = (DestinationFlowspecIpv6Case)obj;
            if (!Objects.equals(_destinationFlowspecIpv6, other.getDestinationFlowspecIpv6())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DestinationFlowspecIpv6CaseImpl otherImpl = (DestinationFlowspecIpv6CaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DestinationFlowspecIpv6Case>>, Augmentation<DestinationFlowspecIpv6Case>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DestinationFlowspecIpv6Case");
            CodeHelpers.appendValue(helper, "_destinationFlowspecIpv6", _destinationFlowspecIpv6);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
