package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.update.attributes.mp.reach.nlri.advertized.routes.destination.type;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.flowspec.l3vpn.destination.ipv4.DestinationFlowspecL3vpnIpv4;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DestinationFlowspecL3vpnIpv4CaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DestinationFlowspecL3vpnIpv4CaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DestinationFlowspecL3vpnIpv4CaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DestinationFlowspecL3vpnIpv4CaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DestinationFlowspecL3vpnIpv4CaseBuilder
 * @see Builder
 *
 */
public class DestinationFlowspecL3vpnIpv4CaseBuilder implements Builder<DestinationFlowspecL3vpnIpv4Case> {

    private DestinationFlowspecL3vpnIpv4 _destinationFlowspecL3vpnIpv4;


    Map<Class<? extends Augmentation<DestinationFlowspecL3vpnIpv4Case>>, Augmentation<DestinationFlowspecL3vpnIpv4Case>> augmentation = Collections.emptyMap();

    public DestinationFlowspecL3vpnIpv4CaseBuilder() {
    }
    public DestinationFlowspecL3vpnIpv4CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnDestinationIpv4 arg) {
        this._destinationFlowspecL3vpnIpv4 = arg.getDestinationFlowspecL3vpnIpv4();
    }

    public DestinationFlowspecL3vpnIpv4CaseBuilder(DestinationFlowspecL3vpnIpv4Case base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DestinationFlowspecL3vpnIpv4Case>>, Augmentation<DestinationFlowspecL3vpnIpv4Case>> aug =((AugmentationHolder<DestinationFlowspecL3vpnIpv4Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._destinationFlowspecL3vpnIpv4 = base.getDestinationFlowspecL3vpnIpv4();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnDestinationIpv4</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnDestinationIpv4) {
            this._destinationFlowspecL3vpnIpv4 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnDestinationIpv4)arg).getDestinationFlowspecL3vpnIpv4();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.flowspec.rev200120.FlowspecL3vpnDestinationIpv4]");
    }

    public DestinationFlowspecL3vpnIpv4 getDestinationFlowspecL3vpnIpv4() {
        return _destinationFlowspecL3vpnIpv4;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DestinationFlowspecL3vpnIpv4Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DestinationFlowspecL3vpnIpv4CaseBuilder setDestinationFlowspecL3vpnIpv4(final DestinationFlowspecL3vpnIpv4 value) {
        this._destinationFlowspecL3vpnIpv4 = value;
        return this;
    }
    
    public DestinationFlowspecL3vpnIpv4CaseBuilder addAugmentation(Class<? extends Augmentation<DestinationFlowspecL3vpnIpv4Case>> augmentationType, Augmentation<DestinationFlowspecL3vpnIpv4Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DestinationFlowspecL3vpnIpv4CaseBuilder removeAugmentation(Class<? extends Augmentation<DestinationFlowspecL3vpnIpv4Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DestinationFlowspecL3vpnIpv4Case build() {
        return new DestinationFlowspecL3vpnIpv4CaseImpl(this);
    }

    private static final class DestinationFlowspecL3vpnIpv4CaseImpl
        extends AbstractAugmentable<DestinationFlowspecL3vpnIpv4Case>
        implements DestinationFlowspecL3vpnIpv4Case {
    
        private final DestinationFlowspecL3vpnIpv4 _destinationFlowspecL3vpnIpv4;
    
        DestinationFlowspecL3vpnIpv4CaseImpl(DestinationFlowspecL3vpnIpv4CaseBuilder base) {
            super(base.augmentation);
            this._destinationFlowspecL3vpnIpv4 = base.getDestinationFlowspecL3vpnIpv4();
        }
    
        @Override
        public DestinationFlowspecL3vpnIpv4 getDestinationFlowspecL3vpnIpv4() {
            return _destinationFlowspecL3vpnIpv4;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_destinationFlowspecL3vpnIpv4);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DestinationFlowspecL3vpnIpv4Case.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DestinationFlowspecL3vpnIpv4Case other = (DestinationFlowspecL3vpnIpv4Case)obj;
            if (!Objects.equals(_destinationFlowspecL3vpnIpv4, other.getDestinationFlowspecL3vpnIpv4())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DestinationFlowspecL3vpnIpv4CaseImpl otherImpl = (DestinationFlowspecL3vpnIpv4CaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DestinationFlowspecL3vpnIpv4Case>>, Augmentation<DestinationFlowspecL3vpnIpv4Case>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DestinationFlowspecL3vpnIpv4Case");
            CodeHelpers.appendValue(helper, "_destinationFlowspecL3vpnIpv4", _destinationFlowspecL3vpnIpv4);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
