/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.DefinedSets1;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.BgpDefinedSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ExtCommunitySets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ext.community.sets.ExtCommunitySet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ext.community.sets.ExtCommunitySetKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class AbstractExtCommunityHandler {
    private static final InstanceIdentifier<ExtCommunitySets> EXT_COMMUNITY_SETS_IID = InstanceIdentifier.create(RoutingPolicy.class).child(DefinedSets.class).augmentation(DefinedSets1.class).child(BgpDefinedSets.class).child(ExtCommunitySets.class);
    private final DataBroker databroker;
    protected final LoadingCache<String, List<ExtendedCommunities>> extCommunitySets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<ExtendedCommunities>>(){

        public List<ExtendedCommunities> load(String key) throws ExecutionException, InterruptedException {
            return AbstractExtCommunityHandler.this.loadCommunitySet(key);
        }
    });

    public AbstractExtCommunityHandler(DataBroker databroker) {
        this.databroker = Objects.requireNonNull(databroker);
    }

    private List<ExtendedCommunities> loadCommunitySet(String key) throws ExecutionException, InterruptedException {
        ReadOnlyTransaction tr = this.databroker.newReadOnlyTransaction();
        Optional result = (Optional)tr.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)EXT_COMMUNITY_SETS_IID.child(ExtCommunitySet.class, (Identifier)new ExtCommunitySetKey(key))).get();
        if (!result.isPresent()) {
            return Collections.emptyList();
        }
        return ((ExtCommunitySet)result.get()).getExtCommunityMember().stream().map(ge -> new ExtendedCommunitiesBuilder().setExtendedCommunity(ge.getExtendedCommunity()).setTransitive(ge.isTransitive()).build()).collect(Collectors.toList());
    }
}

