/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.action.BgpActionAugPolicy;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.action.BgpActionPolicy;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsAugmentationPolicy;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsPolicy;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.AbstractBGPStatementProviderActivator;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.StatementRegistryProvider;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions.AsPathPrepend;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions.LocalAsPathPrependHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions.NonTransitiveAttributesFilterHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions.SetClusterIdPrependHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions.SetCommunityHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions.SetExtCommunityHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions.SetOriginatorIdPrependHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.MatchAfiSafiNotInHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.MatchAsPathSetHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.MatchBgpNeighborSetHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.MatchClusterIdSetHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.MatchCommunitySetHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.MatchExtCommunitySetHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.MatchOriginatorIdSetHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.MatchRoleSetHandler;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions.VpnNonMemberHandler;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.bgp.match.conditions.MatchAsPathSet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.bgp.match.conditions.MatchCommunitySet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.bgp.match.conditions.MatchExtCommunitySet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.SetAsPathPrepend;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.SetCommunity;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.SetExtCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.LocalAsPathPrepend;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.MatchAfiSafiNotInCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.MatchBgpNeighborCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.MatchClusterIdSetCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.MatchOriginatorIdSetCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.MatchRoleSetCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.NonTransitiveAttributesFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.SetClusterIdPrepend;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.SetOriginatorIdPrepend;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.VpnNonMemberCondition;

public final class StatementActivator
extends AbstractBGPStatementProviderActivator {
    private final DataBroker dataBroker;

    public StatementActivator(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    protected synchronized List<AutoCloseable> startImpl(StatementRegistryProvider provider) {
        ArrayList<AutoCloseable> registration = new ArrayList<AutoCloseable>(14);
        this.registerActions(provider, registration);
        this.registerConditions(provider, registration);
        return registration;
    }

    private void registerConditions(StatementRegistryProvider provider, List<AutoCloseable> registration) {
        registration.add((AutoCloseable)provider.registerBgpConditionsAugmentationPolicy(MatchRoleSetCondition.class, (BgpConditionsAugmentationPolicy)new MatchRoleSetHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpConditionsAugmentationPolicy(MatchOriginatorIdSetCondition.class, (BgpConditionsAugmentationPolicy)new MatchOriginatorIdSetHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpConditionsAugmentationPolicy(MatchClusterIdSetCondition.class, (BgpConditionsAugmentationPolicy)new MatchClusterIdSetHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpConditionsPolicy(MatchAsPathSet.class, (BgpConditionsPolicy)new MatchAsPathSetHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpConditionsPolicy(MatchExtCommunitySet.class, (BgpConditionsPolicy)new MatchExtCommunitySetHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpConditionsPolicy(MatchCommunitySet.class, (BgpConditionsPolicy)new MatchCommunitySetHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpConditionsAugmentationPolicy(MatchBgpNeighborCondition.class, (BgpConditionsAugmentationPolicy)new MatchBgpNeighborSetHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpConditionsAugmentationPolicy(MatchAfiSafiNotInCondition.class, (BgpConditionsAugmentationPolicy)MatchAfiSafiNotInHandler.getInstance()));
        registration.add((AutoCloseable)provider.registerBgpConditionsAugmentationPolicy(VpnNonMemberCondition.class, (BgpConditionsAugmentationPolicy)VpnNonMemberHandler.getInstance()));
    }

    private void registerActions(StatementRegistryProvider provider, List<AutoCloseable> registration) {
        registration.add((AutoCloseable)provider.registerBgpActionPolicy(SetAsPathPrepend.class, (BgpActionPolicy)AsPathPrepend.getInstance()));
        registration.add((AutoCloseable)provider.registerBgpActionAugmentationPolicy(LocalAsPathPrepend.class, (BgpActionAugPolicy)LocalAsPathPrependHandler.getInstance()));
        registration.add((AutoCloseable)provider.registerBgpActionPolicy(SetCommunity.class, (BgpActionPolicy)new SetCommunityHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpActionPolicy(SetExtCommunity.class, (BgpActionPolicy)new SetExtCommunityHandler(this.dataBroker)));
        registration.add((AutoCloseable)provider.registerBgpActionAugmentationPolicy(SetOriginatorIdPrepend.class, (BgpActionAugPolicy)SetOriginatorIdPrependHandler.getInstance()));
        registration.add((AutoCloseable)provider.registerBgpActionAugmentationPolicy(NonTransitiveAttributesFilter.class, (BgpActionAugPolicy)NonTransitiveAttributesFilterHandler.getInstance()));
        registration.add((AutoCloseable)provider.registerBgpActionAugmentationPolicy(SetClusterIdPrepend.class, (BgpActionAugPolicy)SetClusterIdPrependHandler.getInstance()));
    }
}

