/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions;

import java.util.List;
import java.util.stream.Collectors;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.action.BgpActionAugPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.NonTransitiveAttributesFilter;

public final class NonTransitiveAttributesFilterHandler
implements BgpActionAugPolicy<NonTransitiveAttributesFilter> {
    private static final NonTransitiveAttributesFilterHandler INSTANCE = new NonTransitiveAttributesFilterHandler();

    private NonTransitiveAttributesFilterHandler() {
    }

    public static NonTransitiveAttributesFilterHandler getInstance() {
        return INSTANCE;
    }

    public Attributes applyImportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, Attributes attributes, NonTransitiveAttributesFilter bgpActions) {
        return this.filterAttributes(attributes);
    }

    private Attributes filterAttributes(Attributes attributes) {
        List oldExt;
        AttributesBuilder builder = new AttributesBuilder();
        builder.setCNextHop(attributes.getCNextHop());
        builder.setOrigin(attributes.getOrigin());
        builder.setAsPath(attributes.getAsPath());
        builder.setCommunities(attributes.getCommunities());
        List oldAtt = attributes.getUnrecognizedAttributes();
        if (oldAtt != null) {
            builder.setUnrecognizedAttributes(attributes.getUnrecognizedAttributes().stream().filter(UnrecognizedAttributes::isTransitive).collect(Collectors.toList()));
        }
        if ((oldExt = attributes.getExtendedCommunities()) != null) {
            builder.setExtendedCommunities(oldExt.stream().filter(ExtendedCommunity::isTransitive).collect(Collectors.toList()));
        }
        return builder.build();
    }

    public Attributes applyExportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, Attributes attributes, NonTransitiveAttributesFilter bgpActions) {
        return this.filterAttributes(attributes);
    }
}

