/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.action.BgpActionAugPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.ClusterIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.SetClusterIdPrepend;

public final class SetClusterIdPrependHandler
implements BgpActionAugPolicy<SetClusterIdPrepend> {
    private static final SetClusterIdPrependHandler INSTANCE = new SetClusterIdPrependHandler();

    private SetClusterIdPrependHandler() {
    }

    public static SetClusterIdPrependHandler getInstance() {
        return INSTANCE;
    }

    public Attributes applyImportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters importParameters, Attributes attributes, SetClusterIdPrepend bgpActions) {
        ClusterIdentifier clusterIdLocal = importParameters.getFromClusterId() == null ? routeEntryInfo.getClusterId() : importParameters.getFromClusterId();
        return this.prependClusterId(attributes, clusterIdLocal);
    }

    private Attributes prependClusterId(Attributes attributes, ClusterIdentifier clusterId) {
        AttributesBuilder newAtt = new AttributesBuilder(attributes);
        ArrayList<ClusterIdentifier> newClusterList = new ArrayList<ClusterIdentifier>();
        newClusterList.add(clusterId);
        if (attributes.getClusterId() != null && !attributes.getClusterId().getCluster().isEmpty()) {
            List oldList = attributes.getClusterId().getCluster();
            newClusterList.addAll(oldList);
        }
        return newAtt.setClusterId(new ClusterIdBuilder().setCluster(newClusterList).build()).build();
    }

    public Attributes applyExportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters exportParameters, Attributes attributes, SetClusterIdPrepend bgpActions) {
        ClusterIdentifier clusterIdLocal = exportParameters.getFromClusterId() == null ? routeEntryInfo.getClusterId() : exportParameters.getFromClusterId();
        return this.prependClusterId(attributes, clusterIdLocal);
    }
}

