/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.action.BgpActionPolicy;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractCommunityHandler;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.BgpSetCommunityOptionType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.SetCommunity;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.set.community.SetCommunityMethod;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.set.community.set.community.method.Inline;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.set.community.set.community.method.Reference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.CommunitiesBuilder;

public final class SetCommunityHandler
extends AbstractCommunityHandler
implements BgpActionPolicy<SetCommunity> {
    public SetCommunityHandler(DataBroker dataBroker) {
        super(dataBroker);
    }

    public Attributes applyImportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, Attributes attributes, SetCommunity bgpActions) {
        return this.setComm(attributes, bgpActions.getSetCommunityMethod(), bgpActions.getOptions());
    }

    public Attributes applyExportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, Attributes attributes, SetCommunity bgpActions) {
        return this.setComm(attributes, bgpActions.getSetCommunityMethod(), bgpActions.getOptions());
    }

    private Attributes setComm(Attributes attributes, SetCommunityMethod setCommunityMethod, BgpSetCommunityOptionType options) {
        if (setCommunityMethod instanceof Inline) {
            Inline inline = (Inline)setCommunityMethod;
            List<Communities> list = inline.getCommunities().stream().map(ge -> new CommunitiesBuilder().setAsNumber(ge.getAsNumber()).setSemantics(ge.getSemantics()).build()).collect(Collectors.toList());
            return this.inlineSetComm(attributes, list, options);
        }
        return this.referenceSetComm(attributes, ((Reference)setCommunityMethod).getCommunitySetRef(), options);
    }

    private Attributes referenceSetComm(Attributes attributes, String communitySetName, BgpSetCommunityOptionType options) {
        String setKey = StringUtils.substringBetween((String)communitySetName, (String)"=\"", (String)"\"");
        return this.inlineSetComm(attributes, (List)this.communitySets.getUnchecked((Object)setKey), options);
    }

    private Attributes inlineSetComm(Attributes attributes, List<Communities> actionCommunities, BgpSetCommunityOptionType options) {
        AttributesBuilder newAtt = new AttributesBuilder(attributes);
        if (options.equals((Object)BgpSetCommunityOptionType.REPLACE)) {
            return newAtt.setCommunities(actionCommunities).build();
        }
        ArrayList<Object> actualComm = attributes.getCommunities() != null ? new ArrayList(attributes.getCommunities()) : new ArrayList<Communities>();
        switch (options) {
            case ADD: {
                actualComm.addAll(actionCommunities);
                break;
            }
            case REMOVE: {
                actualComm.removeAll(actionCommunities);
                break;
            }
            default: {
                throw new IllegalArgumentException("Option Type not Recognized!");
            }
        }
        return newAtt.setCommunities(actualComm).build();
    }
}

