/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsAugmentationPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.DefinedSets1;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.BgpDefinedSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.policy.types.rev151009.MatchSetOptionsRestrictedType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.BgpOriginatorIdSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.match.originator.id.set.condition.grouping.MatchOriginatorIdSetCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.originator.id.set.OriginatorIdSet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.originator.id.set.OriginatorIdSetKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.routing.policy.defined.sets.bgp.defined.sets.OriginatorIdSets;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class MatchOriginatorIdSetHandler
implements BgpConditionsAugmentationPolicy<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.MatchOriginatorIdSetCondition, OriginatorId> {
    private static final InstanceIdentifier<OriginatorIdSets> ORIGINATOR_ID_SETS_IID = InstanceIdentifier.create(RoutingPolicy.class).child(DefinedSets.class).augmentation(DefinedSets1.class).child(BgpDefinedSets.class).augmentation(BgpOriginatorIdSets.class).child(OriginatorIdSets.class);
    private final DataBroker dataBroker;
    private final LoadingCache<String, OriginatorIdSet> sets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, OriginatorIdSet>(){

        public OriginatorIdSet load(String key) throws ExecutionException, InterruptedException {
            return MatchOriginatorIdSetHandler.this.loadSets(key);
        }
    });

    public MatchOriginatorIdSetHandler(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    private OriginatorIdSet loadSets(String key) throws ExecutionException, InterruptedException {
        ReadOnlyTransaction tr = this.dataBroker.newReadOnlyTransaction();
        Optional result = (Optional)tr.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)ORIGINATOR_ID_SETS_IID.child(OriginatorIdSet.class, (Identifier)new OriginatorIdSetKey(key))).get();
        return (OriginatorIdSet)result.orNull();
    }

    public boolean matchImportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, OriginatorId originatorId, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.MatchOriginatorIdSetCondition conditions) {
        return this.matchOriginatorCondition(routeEntryInfo.getOriginatorId(), originatorId, conditions.getMatchOriginatorIdSetCondition());
    }

    public boolean matchExportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, OriginatorId originatorId, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.MatchOriginatorIdSetCondition conditions) {
        return this.matchOriginatorCondition(routeEntryInfo.getOriginatorId(), originatorId, conditions.getMatchOriginatorIdSetCondition());
    }

    public OriginatorId getConditionParameter(Attributes attributes) {
        return attributes.getOriginatorId();
    }

    private boolean matchOriginatorCondition(Ipv4Address localOriginatorId, OriginatorId originatorId, MatchOriginatorIdSetCondition condition) {
        MatchSetOptionsRestrictedType matchOption;
        OriginatorIdSet originatorIdSet = (OriginatorIdSet)this.sets.getUnchecked((Object)StringUtils.substringBetween((String)condition.getOriginatorIdSet(), (String)"=\"", (String)"\""));
        if (originatorIdSet == null) {
            return false;
        }
        boolean found = false;
        if (originatorId != null) {
            Ipv4Address remOrigin = originatorId.getOriginator();
            if (originatorIdSet.getLocal() != null && localOriginatorId.equals((Object)remOrigin)) {
                found = true;
            }
            if (!found && originatorIdSet.getOriginatorId() != null) {
                found = originatorIdSet.getOriginatorId().contains(remOrigin);
            }
        }
        return (matchOption = condition.getMatchSetOptions()).equals((Object)MatchSetOptionsRestrictedType.ANY) && found || matchOption.equals((Object)MatchSetOptionsRestrictedType.INVERT) && !found;
    }
}

