/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsAugmentationPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.RouteTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.As4RouteTargetExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.RouteTargetExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.extended.community.extended.community.RouteTargetIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.route.target.constrain._default.route.grouping.RouteTargetConstrainDefaultRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.route.target.constrain._default.route.grouping.RouteTargetConstrainDefaultRouteBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev180329.VpnNonMemberCondition;

public final class VpnNonMemberHandler
implements BgpConditionsAugmentationPolicy<VpnNonMemberCondition, List<ExtendedCommunities>> {
    private static final VpnNonMemberHandler INSTANCE = new VpnNonMemberHandler();
    private static final RouteTargetConstrainDefaultRoute DEFAULT = new RouteTargetConstrainDefaultRouteBuilder().build();

    private VpnNonMemberHandler() {
    }

    public static VpnNonMemberHandler getInstance() {
        return INSTANCE;
    }

    public boolean matchImportCondition(Class<? extends AfiSafiType> afiSafiType, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, List<ExtendedCommunities> attributes, VpnNonMemberCondition conditions) {
        return false;
    }

    public boolean matchExportCondition(Class<? extends AfiSafiType> afiSafiType, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, List<ExtendedCommunities> attributes, VpnNonMemberCondition conditions) {
        List allowedRouteTarget = routeEntryExportParameters.getMemberships();
        if (allowedRouteTarget.contains(DEFAULT)) {
            return false;
        }
        List toRT = attributes.stream().map(ext -> ext.getExtendedCommunity()).filter(Objects::nonNull).filter(this::filterRTExtComm).map(this::extendedCommunityToRouteTarget).collect(Collectors.toList());
        return Collections.disjoint(allowedRouteTarget, toRT);
    }

    private RouteTarget extendedCommunityToRouteTarget(ExtendedCommunity rt) {
        if (rt instanceof RouteTargetExtendedCommunityCase) {
            return ((RouteTargetExtendedCommunityCase)rt).getRouteTargetExtendedCommunity();
        }
        if (rt instanceof As4RouteTargetExtendedCommunityCase) {
            return ((As4RouteTargetExtendedCommunityCase)rt).getAs4RouteTargetExtendedCommunity();
        }
        return ((RouteTargetIpv4Case)rt).getRouteTargetIpv4();
    }

    private boolean filterRTExtComm(ExtendedCommunity rt) {
        return rt instanceof RouteTargetExtendedCommunityCase || rt instanceof As4RouteTargetExtendedCommunityCase || rt instanceof RouteTargetIpv4Case;
    }

    public List<ExtendedCommunities> getConditionParameter(Attributes attributes) {
        List ext = attributes.getExtendedCommunities();
        return ext == null ? Collections.emptyList() : ext;
    }
}

