/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.action.BgpActionAugPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.UnrecognizedAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.NonTransitiveAttributesFilter;

public final class NonTransitiveAttributesFilterHandler
implements BgpActionAugPolicy<NonTransitiveAttributesFilter> {
    private static final NonTransitiveAttributesFilterHandler INSTANCE = new NonTransitiveAttributesFilterHandler();

    private NonTransitiveAttributesFilterHandler() {
    }

    public static NonTransitiveAttributesFilterHandler getInstance() {
        return INSTANCE;
    }

    public Attributes applyImportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, Attributes attributes, NonTransitiveAttributesFilter bgpActions) {
        return NonTransitiveAttributesFilterHandler.filterAttributes(attributes);
    }

    private static Attributes filterAttributes(Attributes attributes) {
        List oldExt;
        AttributesBuilder builder = new AttributesBuilder().setCNextHop(attributes.getCNextHop()).setOrigin(attributes.getOrigin()).setAsPath(attributes.getAsPath()).setCommunities(attributes.getCommunities());
        Map oldAtt = attributes.getUnrecognizedAttributes();
        if (oldAtt != null) {
            builder.setUnrecognizedAttributes((Map)attributes.getUnrecognizedAttributes().values().stream().filter(UnrecognizedAttributes::isTransitive).collect(ImmutableMap.toImmutableMap(UnrecognizedAttributes::key, Function.identity())));
        }
        if ((oldExt = attributes.getExtendedCommunities()) != null) {
            builder.setExtendedCommunities(oldExt.stream().filter(ExtendedCommunity::isTransitive).collect(Collectors.toList()));
        }
        return builder.build();
    }

    public Attributes applyExportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, Attributes attributes, NonTransitiveAttributesFilter bgpActions) {
        return NonTransitiveAttributesFilterHandler.filterAttributes(attributes);
    }
}

