/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.action.BgpActionPolicy;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractExtCommunityHandler;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.BgpSetCommunityOptionType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.SetExtCommunity;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.set.ext.community.SetExtCommunityMethod;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.set.ext.community.set.ext.community.method.Inline;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.policy.definitions.policy.definition.statements.statement.actions.bgp.actions.set.ext.community.set.ext.community.method.Reference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunitiesBuilder;

public final class SetExtCommunityHandler
extends AbstractExtCommunityHandler
implements BgpActionPolicy<SetExtCommunity> {
    public SetExtCommunityHandler(DataBroker dataBroker) {
        super(dataBroker);
    }

    public Attributes applyImportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, Attributes attributes, SetExtCommunity bgpActions) {
        return this.setExtComm(attributes, bgpActions.getSetExtCommunityMethod(), bgpActions.getOptions());
    }

    public Attributes applyExportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, Attributes attributes, SetExtCommunity bgpActions) {
        return this.setExtComm(attributes, bgpActions.getSetExtCommunityMethod(), bgpActions.getOptions());
    }

    private Attributes setExtComm(Attributes attributes, SetExtCommunityMethod setExtCommunityMethod, BgpSetCommunityOptionType options) {
        if (setExtCommunityMethod instanceof Inline) {
            Inline inline = (Inline)setExtCommunityMethod;
            List<ExtendedCommunities> list = inline.getExtCommunityMember().stream().map(ge -> new ExtendedCommunitiesBuilder().setExtendedCommunity(ge.getExtendedCommunity()).setTransitive(ge.isTransitive()).build()).collect(Collectors.toList());
            return SetExtCommunityHandler.inlineSetExtComm(attributes, list, options);
        }
        return this.referenceSetExtComm(attributes, ((Reference)setExtCommunityMethod).getExtCommunitySetRef(), options);
    }

    private static Attributes inlineSetExtComm(Attributes attributes, List<ExtendedCommunities> actionExtCommunities, BgpSetCommunityOptionType options) {
        AttributesBuilder newAtt = new AttributesBuilder(attributes);
        if (options.equals((Object)BgpSetCommunityOptionType.REPLACE)) {
            return newAtt.setExtendedCommunities(actionExtCommunities).build();
        }
        ArrayList<Object> actualComm = attributes.getCommunities() != null ? new ArrayList(attributes.getExtendedCommunities()) : new ArrayList<ExtendedCommunities>();
        switch (options) {
            case ADD: {
                actualComm.addAll(actionExtCommunities);
                break;
            }
            case REMOVE: {
                actualComm.removeAll(actionExtCommunities);
                break;
            }
            default: {
                throw new IllegalArgumentException("Option Type not Recognized!");
            }
        }
        return newAtt.setExtendedCommunities(actualComm).build();
    }

    private Attributes referenceSetExtComm(Attributes attributes, String extCommunitySetName, BgpSetCommunityOptionType options) {
        String setKey = StringUtils.substringBetween((String)extCommunitySetName, (String)"=\"", (String)"\"");
        return SetExtCommunityHandler.inlineSetExtComm(attributes, (List)this.extCommunitySets.getUnchecked((Object)setKey), options);
    }
}

