/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsAugmentationPolicy;
import org.opendaylight.protocol.bgp.rib.spi.RouterIds;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.policy.types.rev151009.MatchSetOptionsRestrictedType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.generic.defined.sets.NeighborSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.neighbor.set.NeighborSet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.neighbor.set.NeighborSetKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.MatchBgpNeighborCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.match.bgp.neighbor.grouping.MatchBgpNeighborSet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.match.bgp.neighbor.grouping.match.bgp.neighbor.set.FromNeighbor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.match.bgp.neighbor.grouping.match.bgp.neighbor.set.ToNeighbor;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class MatchBgpNeighborSetHandler
implements BgpConditionsAugmentationPolicy<MatchBgpNeighborCondition, Void> {
    private static final InstanceIdentifier<NeighborSets> NEIGHBOR_SET_IID = InstanceIdentifier.create(RoutingPolicy.class).child(DefinedSets.class).child(NeighborSets.class);
    private final DataBroker dataBroker;
    private final LoadingCache<String, List<PeerId>> peerSets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<PeerId>>(){

        public List<PeerId> load(String key) throws ExecutionException, InterruptedException {
            return MatchBgpNeighborSetHandler.this.loadRoleSets(key);
        }
    });

    public MatchBgpNeighborSetHandler(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private List<PeerId> loadRoleSets(String key) throws ExecutionException, InterruptedException {
        ReadTransaction tr = this.dataBroker.newReadOnlyTransaction();
        Optional result = (Optional)tr.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)NEIGHBOR_SET_IID.child(NeighborSet.class, (Identifier)new NeighborSetKey(key))).get();
        if (!result.isPresent()) {
            return Collections.emptyList();
        }
        return ((NeighborSet)result.get()).getNeighbor().values().stream().map(nei -> RouterIds.createPeerId((IpAddress)nei.getAddress())).collect(Collectors.toList());
    }

    public boolean matchImportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters importParameters, Void nonAttributres, MatchBgpNeighborCondition conditions) {
        return this.matchBgpNeighborSetCondition(importParameters.getFromPeerId(), null, conditions.getMatchBgpNeighborSet());
    }

    public boolean matchExportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters exportParameters, Void nonAttributres, MatchBgpNeighborCondition conditions) {
        return this.matchBgpNeighborSetCondition(exportParameters.getFromPeerId(), exportParameters.getToPeerId(), conditions.getMatchBgpNeighborSet());
    }

    private boolean matchBgpNeighborSetCondition(PeerId fromPeerId, PeerId toPeerId, MatchBgpNeighborSet matchBgpNeighborSet) {
        FromNeighbor from = matchBgpNeighborSet.getFromNeighbor();
        Boolean match = null;
        if (from != null) {
            match = this.checkMatch(from.getNeighborSet(), fromPeerId, from.getMatchSetOptions());
        }
        if (match != null && !match.booleanValue()) {
            return false;
        }
        ToNeighbor to = matchBgpNeighborSet.getToNeighbor();
        if (to != null) {
            match = this.checkMatch(to.getNeighborSet(), toPeerId, to.getMatchSetOptions());
        }
        return match;
    }

    private boolean checkMatch(String neighborSetName, PeerId peerId, MatchSetOptionsRestrictedType matchSetOptions) {
        List roles = (List)this.peerSets.getUnchecked((Object)StringUtils.substringBetween((String)neighborSetName, (String)"=\"", (String)"\""));
        boolean found = roles.contains(peerId);
        if (MatchSetOptionsRestrictedType.ANY.equals((Object)matchSetOptions)) {
            return found;
        }
        return !found;
    }

    public Void getConditionParameter(Attributes attributes) {
        return null;
    }
}

