/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsPolicy;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractCommunityHandler;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.bgp.match.conditions.MatchCommunitySet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.policy.types.rev151009.MatchSetOptionsType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Communities;

public final class MatchCommunitySetHandler
extends AbstractCommunityHandler
implements BgpConditionsPolicy<MatchCommunitySet, List<Communities>> {
    public MatchCommunitySetHandler(DataBroker databroker) {
        super(databroker);
    }

    public boolean matchImportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, List<Communities> communities, MatchCommunitySet conditions) {
        return this.matchCondition(communities, conditions.getCommunitySet(), conditions.getMatchSetOptions());
    }

    public boolean matchExportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, List<Communities> communities, MatchCommunitySet conditions) {
        return this.matchCondition(communities, conditions.getCommunitySet(), conditions.getMatchSetOptions());
    }

    public List<Communities> getConditionParameter(Attributes attributes) {
        return attributes.getCommunities();
    }

    private boolean matchCondition(List<Communities> communities, String communitySetName, MatchSetOptionsType matchSetOptions) {
        String setKey = StringUtils.substringBetween((String)communitySetName, (String)"=\"", (String)"\"");
        List communityFilter = (List)this.communitySets.getUnchecked((Object)setKey);
        if (communityFilter == null || communityFilter.isEmpty()) {
            return false;
        }
        List<Object> commAttributeList = communities == null ? Collections.emptyList() : communities;
        if (matchSetOptions.equals((Object)MatchSetOptionsType.ALL)) {
            return commAttributeList.containsAll(communityFilter) && communityFilter.containsAll(commAttributeList);
        }
        boolean noneInCommon = Collections.disjoint(commAttributeList, communityFilter);
        if (matchSetOptions.equals((Object)MatchSetOptionsType.ANY)) {
            return !noneInCommon;
        }
        return noneInCommon;
    }
}

