/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FluentFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.DefinedSets1;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.BgpDefinedSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ExtCommunitySets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ext.community.sets.ExtCommunitySet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ext.community.sets.ExtCommunitySetKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ext.community.sets.ext.community.set.ExtCommunityMember;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class AbstractExtCommunityHandler {
    private static final InstanceIdentifier<ExtCommunitySets> EXT_COMMUNITY_SETS_IID = InstanceIdentifier.create(RoutingPolicy.class).child(DefinedSets.class).augmentation(DefinedSets1.class).child(BgpDefinedSets.class).child(ExtCommunitySets.class);
    private final DataBroker databroker;
    protected final LoadingCache<String, List<ExtendedCommunities>> extCommunitySets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<ExtendedCommunities>>(){

        public List<ExtendedCommunities> load(String key) throws ExecutionException, InterruptedException {
            return AbstractExtCommunityHandler.this.loadCommunitySet(key);
        }
    });

    public AbstractExtCommunityHandler(DataBroker databroker) {
        this.databroker = Objects.requireNonNull(databroker);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private List<ExtendedCommunities> loadCommunitySet(String key) throws ExecutionException, InterruptedException {
        FluentFuture future;
        try (ReadTransaction tr = this.databroker.newReadOnlyTransaction();){
            future = tr.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)EXT_COMMUNITY_SETS_IID.child(ExtCommunitySet.class, (Identifier)new ExtCommunitySetKey(key)));
        }
        Optional result = (Optional)future.get();
        return result.map(AbstractExtCommunityHandler::toExtendedCommunitiesList).orElse(Collections.emptyList());
    }

    private static List<ExtendedCommunities> toExtendedCommunitiesList(ExtCommunitySet extCommunitySets) {
        return extCommunitySets.getExtCommunityMember().stream().map(AbstractExtCommunityHandler::toExtendedCommunities).collect(Collectors.toList());
    }

    private static ExtendedCommunities toExtendedCommunities(ExtCommunityMember ge) {
        return new ExtendedCommunitiesBuilder().setExtendedCommunity(ge.getExtendedCommunity()).setTransitive(ge.getTransitive()).build();
    }
}

