/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ClusterIdentifier;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class ExportAttributeTestUtil {
    public static final Uint32 REMOTE_AS = Uint32.valueOf((int)8);
    public static final AsNumber LOCAL_AS = new AsNumber(Uint32.valueOf((int)65));
    public static final Ipv4AddressNoZone IPV4 = new Ipv4AddressNoZone("1.2.3.4");
    public static final ClusterIdentifier CLUSTER = new ClusterIdentifier(IPV4);

    private ExportAttributeTestUtil() {
    }

    public static Attributes createInputWithOriginator() {
        return new AttributesBuilder().setClusterId(ExportAttributeTestUtil.createClusterId()).setOriginatorId(ExportAttributeTestUtil.createOriginatorId()).build();
    }

    public static Attributes createClusterInput() {
        return new AttributesBuilder().setClusterId(ExportAttributeTestUtil.createClusterIdInput()).build();
    }

    private static ClusterId createClusterId() {
        ClusterIdentifier cluster1 = new ClusterIdentifier(new Ipv4AddressNoZone("1.1.1.1"));
        ClusterIdentifier cluster2 = new ClusterIdentifier(new Ipv4AddressNoZone("1.1.1.2"));
        return new ClusterIdBuilder().setCluster(Arrays.asList(CLUSTER, cluster1, cluster2)).build();
    }

    private static ClusterId createClusterIdInput() {
        ClusterIdentifier cluster1 = new ClusterIdentifier(new Ipv4AddressNoZone("1.1.1.1"));
        ClusterIdentifier cluster2 = new ClusterIdentifier(new Ipv4AddressNoZone("1.1.1.2"));
        return new ClusterIdBuilder().setCluster(Arrays.asList(cluster1, cluster2)).build();
    }

    private static OriginatorId createOriginatorId() {
        return new OriginatorIdBuilder().setOriginator(IPV4).build();
    }

    static Attributes createPathInputWithAs() {
        return ExportAttributeTestUtil.createPathInput(ExportAttributeTestUtil.createSequenceWithLocalAs());
    }

    static Attributes createPathInput(List<Segments> segB) {
        return new AttributesBuilder().setAsPath(new AsPathBuilder().setSegments(segB).build()).build();
    }

    private static List<Segments> createSequenceWithLocalAs() {
        return Collections.singletonList(new SegmentsBuilder().setAsSequence(Arrays.asList(new AsNumber(LOCAL_AS), new AsNumber(REMOTE_AS))).build());
    }
}

