/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.impl.PolicyRIBBaseParametersImpl;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.RouteAttributeContainer;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractStatementRegistryConsumerTest;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.ImportAttributeTestUtil;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.IPV4UNICAST;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.statements.Statement;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerRole;

public class ImportDefaultStatementTest
extends AbstractStatementRegistryConsumerTest {
    @Mock
    private BGPRouteEntryImportParameters importParameters;
    private List<Statement> defaultImportStatements;
    private PolicyRIBBaseParametersImpl baseAttributes;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.defaultImportStatements = this.loadStatement("default-odl-import-policy");
        this.baseAttributes = new PolicyRIBBaseParametersImpl(8L, IPV4, CLUSTER);
    }

    @Test
    public void testFromEbgp() {
        Statement statement = this.getStatement("from-external");
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ImportAttributeTestUtil.createInput());
        this.assertApplyImportStatement(statement, PeerRole.Ebgp, attributeContainer, ImportAttributeTestUtil.createOutput());
    }

    @Test
    public void testFromNonExternal() {
        Statement statement = this.getStatement("from-non-external");
        Attributes expected = ImportAttributeTestUtil.createInput();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)expected);
        this.assertApplyImportStatement(statement, PeerRole.Ibgp, attributeContainer, expected);
        this.assertApplyImportStatement(statement, PeerRole.RrClient, attributeContainer, expected);
        this.assertApplyImportStatement(statement, PeerRole.Internal, attributeContainer, expected);
    }

    private Statement getStatement(String statementName) {
        return this.defaultImportStatements.stream().filter(st -> st.getName().equals(statementName)).findFirst().get();
    }

    private void assertApplyImportStatement(Statement statement, PeerRole fromPeerRole, RouteAttributeContainer attInput, Attributes attExpected) {
        ((BGPRouteEntryImportParameters)Mockito.doReturn((Object)fromPeerRole).when((Object)this.importParameters)).getFromPeerRole();
        ((BGPRouteEntryImportParameters)Mockito.doReturn((Object)ImportAttributeTestUtil.AS).when((Object)this.importParameters)).getFromPeerLocalAs();
        RouteAttributeContainer result = this.statementRegistry.applyImportStatement((RouteEntryBaseAttributes)this.baseAttributes, IPV4UNICAST.class, this.importParameters, attInput, statement);
        Assert.assertEquals((Object)attExpected, (Object)result.getAttributes());
    }
}

