/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.impl.PolicyRIBBaseParametersImpl;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.RouteAttributeContainer;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractStatementRegistryConsumerTest;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.IPV4UNICAST;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.statements.Statement;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.CommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerRole;
import org.opendaylight.yangtools.yang.common.Uint16;

public class SetCommunityTest
extends AbstractStatementRegistryConsumerTest {
    private final Attributes multipleCom = new AttributesBuilder().setCommunities(Arrays.asList(new CommunitiesBuilder().setAsNumber(AsNumber.getDefaultInstance((String)"65")).setSemantics(Uint16.valueOf((int)10)).build(), new CommunitiesBuilder().setAsNumber(AsNumber.getDefaultInstance((String)"66")).setSemantics(Uint16.valueOf((int)11)).build())).build();
    private final Attributes emptyCom = new AttributesBuilder().setCommunities(Collections.emptyList()).build();
    @Mock
    private BGPRouteEntryExportParameters exportParameters;
    private List<Statement> basicStatements;
    private PolicyRIBBaseParametersImpl baseAttributes;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.basicStatements = this.loadStatement("set-community-statements-test");
        this.baseAttributes = new PolicyRIBBaseParametersImpl(8L, IPV4, CLUSTER);
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)PeerRole.Ibgp).when((Object)this.exportParameters)).getFromPeerRole();
    }

    @Test
    public void testInlineAdd() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("set-community-inline-add-test")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, IPV4UNICAST.class, this.exportParameters, attributeContainer, statement);
        Assert.assertEquals((Object)this.multipleCom, (Object)result.getAttributes());
    }

    @Test
    public void testInlineReplace() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("set-community-inline-replace-test")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, IPV4UNICAST.class, this.exportParameters, attributeContainer, statement);
        Assert.assertEquals((Object)this.multipleCom, (Object)result.getAttributes());
    }

    @Test
    public void testInlineRemove() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("set-community-inline-remove-test")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)this.multipleCom);
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, IPV4UNICAST.class, this.exportParameters, attributeContainer, statement);
        Assert.assertEquals((Object)this.emptyCom, (Object)result.getAttributes());
    }

    @Test
    public void testReferenceAdd() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("set-community-reference-add-test")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, IPV4UNICAST.class, this.exportParameters, attributeContainer, statement);
        Assert.assertEquals((Object)this.multipleCom, (Object)result.getAttributes());
    }

    @Test
    public void testReferenceReplace() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("set-community-reference-replace-test")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, IPV4UNICAST.class, this.exportParameters, attributeContainer, statement);
        Assert.assertEquals((Object)this.multipleCom, (Object)result.getAttributes());
    }

    @Test
    public void testReferenceRemove() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("set-community-reference-remove-test")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)this.multipleCom);
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, IPV4UNICAST.class, this.exportParameters, attributeContainer, statement);
        Assert.assertEquals((Object)this.emptyCom, (Object)result.getAttributes());
    }
}

