/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsPolicy;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractExtCommunityHandler;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.bgp.match.conditions.MatchExtCommunitySet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.policy.types.rev151009.MatchSetOptionsType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;

public final class MatchExtCommunitySetHandler
extends AbstractExtCommunityHandler
implements BgpConditionsPolicy<MatchExtCommunitySet, List<ExtendedCommunities>> {
    public MatchExtCommunitySetHandler(DataBroker databroker) {
        super(databroker);
    }

    private boolean matchCondition(List<ExtendedCommunities> extendedCommunities, String matchExtCommunitySetName, MatchSetOptionsType matchSetOptions) {
        String setKey = StringUtils.substringBetween((String)matchExtCommunitySetName, (String)"=\"", (String)"\"");
        List extCommunityfilter = (List)this.extCommunitySets.getUnchecked((Object)setKey);
        if (extCommunityfilter == null || extCommunityfilter.isEmpty()) {
            return false;
        }
        List<Object> extCommList = extendedCommunities == null ? Collections.emptyList() : extendedCommunities;
        if (matchSetOptions.equals((Object)MatchSetOptionsType.ALL)) {
            return extCommList.containsAll(extCommunityfilter) && extCommunityfilter.containsAll(extCommList);
        }
        boolean noneInCommon = Collections.disjoint(extCommList, extCommunityfilter);
        if (matchSetOptions.equals((Object)MatchSetOptionsType.ANY)) {
            return !noneInCommon;
        }
        return noneInCommon;
    }

    public boolean matchImportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, List<ExtendedCommunities> extendedCommunities, MatchExtCommunitySet conditions) {
        return this.matchCondition(extendedCommunities, conditions.getExtCommunitySet(), conditions.getMatchSetOptions());
    }

    public boolean matchExportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, List<ExtendedCommunities> extendedCommunities, MatchExtCommunitySet conditions) {
        return this.matchCondition(extendedCommunities, conditions.getExtCommunitySet(), conditions.getMatchSetOptions());
    }

    public List<ExtendedCommunities> getConditionParameter(Attributes attributes) {
        return attributes.getExtendedCommunities();
    }
}

