/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FluentFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsAugmentationPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.DefinedSets1;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.BgpDefinedSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.policy.types.rev151009.MatchSetOptionsRestrictedType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.BgpRoleSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.MatchRoleSetCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.bgp.role.sets.RoleSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.match.role.set.condition.grouping.MatchRoleSet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.match.role.set.condition.grouping.match.role.set.FromRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.match.role.set.condition.grouping.match.role.set.ToRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.role.set.RoleSet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.role.set.RoleSetKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class MatchRoleSetHandler
implements BgpConditionsAugmentationPolicy<MatchRoleSetCondition, Void> {
    private static final InstanceIdentifier<RoleSets> ROLE_SET_IID = InstanceIdentifier.create(RoutingPolicy.class).child(DefinedSets.class).augmentation(DefinedSets1.class).child(BgpDefinedSets.class).augmentation(BgpRoleSets.class).child(RoleSets.class);
    private final DataBroker dataBroker;
    private final LoadingCache<String, List<PeerRole>> roleSets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<PeerRole>>(){

        public List<PeerRole> load(String key) throws ExecutionException, InterruptedException {
            return MatchRoleSetHandler.this.loadRoleSets(key);
        }
    });

    public MatchRoleSetHandler(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private List<PeerRole> loadRoleSets(String key) throws ExecutionException, InterruptedException {
        FluentFuture future;
        try (ReadTransaction tr = this.dataBroker.newReadOnlyTransaction();){
            future = tr.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)ROLE_SET_IID.child(RoleSet.class, (Identifier)new RoleSetKey(key)));
        }
        return ((Optional)future.get()).map(RoleSet::getRole).orElse(Collections.emptyList());
    }

    public boolean matchImportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters importParameters, Void attributes, MatchRoleSetCondition conditions) {
        return this.matchNeighborRoleSetCondition(importParameters.getFromPeerRole(), null, conditions.getMatchRoleSet());
    }

    private boolean matchNeighborRoleSetCondition(PeerRole fromPeerRole, PeerRole toPeerRole, MatchRoleSet matchRoleSet) {
        FromRole from = matchRoleSet.getFromRole();
        Boolean match = null;
        if (from != null) {
            match = this.checkMatch(from.getRoleSet(), fromPeerRole, from.getMatchSetOptions());
        }
        if (match != null && !match.booleanValue()) {
            return false;
        }
        ToRole to = matchRoleSet.getToRole();
        if (to != null) {
            match = this.checkMatch(to.getRoleSet(), toPeerRole, to.getMatchSetOptions());
        }
        return match;
    }

    private boolean checkMatch(String roleSetName, PeerRole role, MatchSetOptionsRestrictedType matchSetOptions) {
        List roles = (List)this.roleSets.getUnchecked((Object)StringUtils.substringBetween((String)roleSetName, (String)"=\"", (String)"\""));
        boolean found = roles.contains(role);
        if (MatchSetOptionsRestrictedType.ANY.equals((Object)matchSetOptions)) {
            return found;
        }
        return !found;
    }

    public boolean matchExportCondition(Class<? extends AfiSafiType> afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters exportParameters, Void attributes, MatchRoleSetCondition conditions) {
        return this.matchNeighborRoleSetCondition(exportParameters.getFromPeerRole(), exportParameters.getToPeerRole(), conditions.getMatchRoleSet());
    }

    public Void getConditionParameter(Attributes attributes) {
        return null;
    }
}

