/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.impl.PolicyRIBBaseParametersImpl;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.RouteAttributeContainer;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractStatementRegistryConsumerTest;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.ExportAttributeTestUtil;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.ImportAttributeTestUtil;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.IPV4UNICAST;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.statements.Statement;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerRole;

public class ExportDefaultStatementTest
extends AbstractStatementRegistryConsumerTest {
    @Mock
    private BGPRouteEntryExportParameters exportParameters;
    private List<Statement> defaultExportStatements;
    private PolicyRIBBaseParametersImpl baseAttributes;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.defaultExportStatements = this.loadStatement("default-odl-export-policy");
        this.baseAttributes = new PolicyRIBBaseParametersImpl(8L, IPV4, CLUSTER);
    }

    @Test
    public void testToEbgp() {
        Statement statement = this.getStatementAndSetToRole("to-external", PeerRole.Ebgp);
        Attributes expectedOutput = ExportAttributeTestUtil.createPathInputWithAs();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createPathInput(List.of()));
        this.assertApplyExportStatement(statement, PeerRole.Ebgp, attributeContainer, expectedOutput);
        this.assertApplyExportStatement(statement, PeerRole.Ibgp, attributeContainer, expectedOutput);
        this.assertApplyExportStatement(statement, PeerRole.Internal, attributeContainer, expectedOutput);
        this.assertApplyExportStatement(statement, PeerRole.RrClient, attributeContainer, expectedOutput);
    }

    @Test
    public void testFromInternalToInternal() {
        Statement statement = this.getStatementAndSetToRole("from-internal-to-internal", PeerRole.Ibgp);
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createClusterInput());
        this.assertApplyExportStatement(statement, PeerRole.Ibgp, attributeContainer, null);
    }

    @Test
    public void testFromExternalToInternal() {
        Statement statement = this.getStatementAndSetToRole("from-external-to-internal", PeerRole.Ibgp);
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createClusterInput());
        this.assertApplyExportStatement(statement, PeerRole.Ebgp, attributeContainer, attributeContainer.getAttributes());
    }

    @Test
    public void testFromOdlInternalToInternal() {
        Statement statement = this.getStatementAndSetToRole("from-odl-internal-to-internal-or-rr-client", PeerRole.Ibgp);
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createClusterInput());
        this.assertApplyExportStatement(statement, PeerRole.Internal, attributeContainer, ExportAttributeTestUtil.createClusterInput());
    }

    @Test
    public void testFromRRclientToInternal() {
        Statement statement = this.getStatementAndSetToRole("from-rr-client-to-internal", PeerRole.Ibgp);
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createClusterInput());
        this.assertApplyExportStatement(statement, PeerRole.RrClient, attributeContainer, ExportAttributeTestUtil.createInputWithOriginator());
    }

    @Test
    public void testOdlInternal() {
        Statement statement = this.getStatementAndSetToRole("to-odl-internal", PeerRole.Internal);
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createClusterInput());
        this.assertApplyExportStatement(statement, PeerRole.Ebgp, attributeContainer, null);
        this.assertApplyExportStatement(statement, PeerRole.Ibgp, attributeContainer, null);
        this.assertApplyExportStatement(statement, PeerRole.Internal, attributeContainer, null);
        this.assertApplyExportStatement(statement, PeerRole.RrClient, attributeContainer, null);
    }

    @Test
    public void testFromExternalToRRClient() {
        Statement statement = this.getStatementAndSetToRole("from-external-to-route-reflector", PeerRole.RrClient);
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createClusterInput());
        this.assertApplyExportStatement(statement, PeerRole.Ebgp, attributeContainer, attributeContainer.getAttributes());
    }

    @Test
    public void testFromInternalOrRRClientToRRClient() {
        Statement statement = this.getStatementAndSetToRole("from-internal-or-rr-client-to-route-reflector", PeerRole.RrClient);
        Attributes expectedOutput = ExportAttributeTestUtil.createInputWithOriginator();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createClusterInput());
        this.assertApplyExportStatement(statement, PeerRole.Ibgp, attributeContainer, expectedOutput);
        this.assertApplyExportStatement(statement, PeerRole.RrClient, attributeContainer, expectedOutput);
    }

    @Test
    public void testFromOdlInternalToRRClient() {
        Statement statement = this.getStatementAndSetToRole("from-odl-internal-to-internal-or-rr-client", PeerRole.RrClient);
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)ExportAttributeTestUtil.createClusterInput());
        this.assertApplyExportStatement(statement, PeerRole.Internal, attributeContainer, ExportAttributeTestUtil.createClusterInput());
    }

    private Statement getStatementAndSetToRole(String statementName, PeerRole toPeerRole) {
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)toPeerRole).when((Object)this.exportParameters)).getToPeerRole();
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)ImportAttributeTestUtil.AS).when((Object)this.exportParameters)).getToPeerLocalAs();
        return this.defaultExportStatements.stream().filter(st -> st.getName().equals(statementName)).findFirst().get();
    }

    private void assertApplyExportStatement(Statement statement, PeerRole fromPeerRole, RouteAttributeContainer attInput, Attributes attExpected) {
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)fromPeerRole).when((Object)this.exportParameters)).getFromPeerRole();
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attInput, statement);
        Assert.assertEquals((Object)attExpected, (Object)result.getAttributes());
    }
}

