/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.impl.PolicyRIBBaseParametersImpl;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.RouteAttributeContainer;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractStatementRegistryConsumerTest;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.IPV4UNICAST;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.statements.Statement;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.SegmentsBuilder;

public class MatchAsPathSetTest
extends AbstractStatementRegistryConsumerTest {
    @Mock
    private BGPRouteEntryExportParameters exportParameters;
    private List<Statement> basicStatements;
    private PolicyRIBBaseParametersImpl baseAttributes;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.basicStatements = this.loadStatement("match-as-path-set-test");
        this.baseAttributes = new PolicyRIBBaseParametersImpl(8L, IPV4, CLUSTER);
    }

    @Test
    public void testMatchAsPathAny() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("reject-match-as-path-any-set")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
        attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setAsPath(new AsPathBuilder().setSegments(List.of(new SegmentsBuilder().setAsSequence(List.of(AsNumber.getDefaultInstance((String)"65"))).build())).build()).build());
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
    }

    @Test
    public void testMatchAsPathAll() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("reject-match-as-path-all-set")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setAsPath(new AsPathBuilder().setSegments(List.of(new SegmentsBuilder().setAsSequence(List.of(AsNumber.getDefaultInstance((String)"65"))).build())).build()).build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
        attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setAsPath(new AsPathBuilder().setSegments(List.of(new SegmentsBuilder().setAsSet(Set.of(AsNumber.getDefaultInstance((String)"65"), AsNumber.getDefaultInstance((String)"64"))).build(), new SegmentsBuilder().setAsSet(Set.of(AsNumber.getDefaultInstance((String)"63"))).build())).build()).build());
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
    }

    @Test
    public void testMatchAsPathInverse() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("reject-match-as-path-inverse-set")).findFirst().get();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setAsPath(new AsPathBuilder().setSegments(List.of(new SegmentsBuilder().setAsSequence(List.of(AsNumber.getDefaultInstance((String)"65"))).build())).build()).build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
        attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setAsPath(new AsPathBuilder().setSegments(List.of(new SegmentsBuilder().setAsSequence(List.of(AsNumber.getDefaultInstance((String)"200"))).build())).build()).build());
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
    }
}

