/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.impl.PolicyRIBBaseParametersImpl;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.RouteAttributeContainer;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractStatementRegistryConsumerTest;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.IPV4UNICAST;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.statements.Statement;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.EncapsulationTunnelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.as._4.spec.common.As4SpecificCommonBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.As4RouteOriginExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.EncapsulationCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.as._4.route.origin.extended.community._case.As4RouteOriginExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.encapsulation._case.EncapsulationExtendedCommunityBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;

public class MatchExtComTest
extends AbstractStatementRegistryConsumerTest {
    @Mock
    private BGPRouteEntryExportParameters exportParameters;
    private List<Statement> basicStatements;
    private PolicyRIBBaseParametersImpl baseAttributes;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.basicStatements = this.loadStatement("ext-community-statements-test");
        this.baseAttributes = new PolicyRIBBaseParametersImpl(8L, IPV4, CLUSTER);
    }

    @Test
    public void testExtComAny() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("ext-community-any-test")).findFirst().orElseThrow();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
        attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setExtendedCommunities(List.of(new ExtendedCommunitiesBuilder().setExtendedCommunity((ExtendedCommunity)new As4RouteOriginExtendedCommunityCaseBuilder().setAs4RouteOriginExtendedCommunity(new As4RouteOriginExtendedCommunityBuilder().setAs4SpecificCommon(new As4SpecificCommonBuilder().setAsNumber(AsNumber.getDefaultInstance((String)"65000")).setLocalAdministrator(Uint16.valueOf((int)123)).build()).build()).build()).build())).build());
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
    }

    @Test
    public void testExtComAll() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("ext-community-all-test")).findFirst().orElseThrow();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
        attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setExtendedCommunities(List.of(new ExtendedCommunitiesBuilder().setExtendedCommunity((ExtendedCommunity)new As4RouteOriginExtendedCommunityCaseBuilder().setAs4RouteOriginExtendedCommunity(new As4RouteOriginExtendedCommunityBuilder().setAs4SpecificCommon(new As4SpecificCommonBuilder().setAsNumber(AsNumber.getDefaultInstance((String)"65000")).setLocalAdministrator(Uint16.valueOf((int)123)).build()).build()).build()).build(), new ExtendedCommunitiesBuilder().setExtendedCommunity((ExtendedCommunity)new EncapsulationCaseBuilder().setEncapsulationExtendedCommunity(new EncapsulationExtendedCommunityBuilder().setTunnelType(EncapsulationTunnelType.Vxlan).build()).build()).build())).build());
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
    }

    @Test
    public void testExtComInvert() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("ext-community-invert-test")).findFirst().orElseThrow();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
        attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setExtendedCommunities(List.of(new ExtendedCommunitiesBuilder().setExtendedCommunity((ExtendedCommunity)new As4RouteOriginExtendedCommunityCaseBuilder().setAs4RouteOriginExtendedCommunity(new As4RouteOriginExtendedCommunityBuilder().setAs4SpecificCommon(new As4SpecificCommonBuilder().setAsNumber(AsNumber.getDefaultInstance((String)"65000")).setLocalAdministrator(Uint16.valueOf((int)123)).build()).build()).build()).build())).build());
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
    }
}

