/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.actions;

import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.action.BgpActionAugPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.SetOriginatorIdPrepend;

public final class SetOriginatorIdPrependHandler
implements BgpActionAugPolicy<SetOriginatorIdPrepend> {
    private static final SetOriginatorIdPrependHandler INSTANCE = new SetOriginatorIdPrependHandler();

    private SetOriginatorIdPrependHandler() {
    }

    public static SetOriginatorIdPrependHandler getInstance() {
        return INSTANCE;
    }

    public Attributes applyImportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, Attributes attributes, SetOriginatorIdPrepend bgpActions) {
        Ipv4AddressNoZone defOri = bgpActions.getSetOriginatorIdPrepend().getOriginatorId();
        return SetOriginatorIdPrependHandler.prependOriginatorId(attributes, defOri == null ? routeEntryInfo.getOriginatorId() : defOri);
    }

    private static Attributes prependOriginatorId(Attributes attributes, Ipv4AddressNoZone originatorId) {
        if (attributes.getOriginatorId() != null) {
            return attributes;
        }
        AttributesBuilder newAtt = new AttributesBuilder(attributes);
        return newAtt.setOriginatorId(new OriginatorIdBuilder().setOriginator(originatorId).build()).build();
    }

    public Attributes applyExportAction(RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, Attributes attributes, SetOriginatorIdPrepend bgpActions) {
        Ipv4AddressNoZone defOri = bgpActions.getSetOriginatorIdPrepend().getOriginatorId();
        return SetOriginatorIdPrependHandler.prependOriginatorId(attributes, defOri == null ? routeEntryInfo.getOriginatorId() : defOri);
    }
}

