/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsAugmentationPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.DefinedSets1;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.BgpDefinedSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.policy.types.rev151009.MatchSetOptionsType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.OpenconfigRoutingPolicyData;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ClusterIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.BgpClusterIdSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.bgp.cluster.id.sets.ClusterIdSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.cluster.id.set.ClusterIdSet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.cluster.id.set.ClusterIdSetKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.match.cluster.id.set.condition.grouping.MatchClusterIdSetCondition;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;

public final class MatchClusterIdSetHandler
implements BgpConditionsAugmentationPolicy<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.MatchClusterIdSetCondition, ClusterId> {
    private static final InstanceIdentifier<ClusterIdSets> CLUSTERS_ID_SETS_IID = InstanceIdentifier.builderOfInherited(OpenconfigRoutingPolicyData.class, RoutingPolicy.class).build().child(DefinedSets.class).augmentation(DefinedSets1.class).child(BgpDefinedSets.class).augmentation(BgpClusterIdSets.class).child(ClusterIdSets.class);
    private final DataBroker dataBroker;
    private final LoadingCache<String, ClusterIdSet> sets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ClusterIdSet>(){

        public ClusterIdSet load(String key) throws ExecutionException, InterruptedException {
            return MatchClusterIdSetHandler.this.loadSets(key);
        }
    });

    public MatchClusterIdSetHandler(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    private ClusterIdSet loadSets(String key) throws ExecutionException, InterruptedException {
        FluentFuture future;
        try (ReadTransaction tr = this.dataBroker.newReadOnlyTransaction();){
            future = tr.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)CLUSTERS_ID_SETS_IID.child(ClusterIdSet.class, (Key)new ClusterIdSetKey(key)));
        }
        return ((Optional)future.get()).orElse(null);
    }

    public boolean matchImportCondition(AfiSafiType afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters importParameters, ClusterId clusterIdAtt, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.MatchClusterIdSetCondition conditions) {
        ClusterIdentifier clusterIdLocal = importParameters.getFromClusterId() == null ? routeEntryInfo.getClusterId() : importParameters.getFromClusterId();
        return this.matchClusterIdCondition(clusterIdLocal, clusterIdAtt, conditions.getMatchClusterIdSetCondition());
    }

    public boolean matchExportCondition(AfiSafiType afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters exportParameters, ClusterId clusterIdAtt, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.MatchClusterIdSetCondition conditions) {
        ClusterIdentifier clusterIdLocal = exportParameters.getFromClusterId() == null ? routeEntryInfo.getClusterId() : exportParameters.getFromClusterId();
        return this.matchClusterIdCondition(clusterIdLocal, clusterIdAtt, conditions.getMatchClusterIdSetCondition());
    }

    public ClusterId getConditionParameter(Attributes attributes) {
        return attributes.getClusterId();
    }

    private boolean matchClusterIdCondition(ClusterIdentifier localClusterId, ClusterId clusterId, MatchClusterIdSetCondition matchClusterIdSetCondition) {
        ClusterIdSet clusterIdSet = (ClusterIdSet)this.sets.getUnchecked((Object)StringUtils.substringBetween((String)matchClusterIdSetCondition.getClusterIdSet(), (String)"=\"", (String)"\""));
        if (clusterIdSet == null) {
            return false;
        }
        MatchSetOptionsType matchOption = matchClusterIdSetCondition.getMatchSetOptions();
        if (clusterId != null) {
            ArrayList<ClusterIdentifier> newList = new ArrayList<ClusterIdentifier>();
            if (clusterIdSet.getClusterId() != null) {
                newList.addAll(clusterIdSet.getClusterId());
            }
            if (clusterIdSet.getLocal() != null) {
                newList.add(localClusterId);
            }
            List matchClusterList = clusterId.getCluster();
            if (matchOption.equals((Object)MatchSetOptionsType.ALL)) {
                return matchClusterList.containsAll(newList) && newList.containsAll(matchClusterList);
            }
            boolean noneInCommon = Collections.disjoint(matchClusterList, newList);
            if (matchOption.equals((Object)MatchSetOptionsType.ANY)) {
                return !noneInCommon;
            }
            if (matchOption.equals((Object)MatchSetOptionsType.INVERT)) {
                return noneInCommon;
            }
        } else if (matchOption.equals((Object)MatchSetOptionsType.INVERT)) {
            return true;
        }
        return false;
    }
}

