/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsAugmentationPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.DefinedSets1;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.BgpDefinedSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.policy.types.rev151009.MatchSetOptionsRestrictedType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.OpenconfigRoutingPolicyData;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.BgpOriginatorIdSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.bgp.originator.id.sets.OriginatorIdSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.match.originator.id.set.condition.grouping.MatchOriginatorIdSetCondition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.originator.id.set.OriginatorIdSet;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.originator.id.set.OriginatorIdSetKey;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;

public final class MatchOriginatorIdSetHandler
implements BgpConditionsAugmentationPolicy<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.MatchOriginatorIdSetCondition, OriginatorId> {
    private static final InstanceIdentifier<OriginatorIdSets> ORIGINATOR_ID_SETS_IID = InstanceIdentifier.builderOfInherited(OpenconfigRoutingPolicyData.class, RoutingPolicy.class).build().child(DefinedSets.class).augmentation(DefinedSets1.class).child(BgpDefinedSets.class).augmentation(BgpOriginatorIdSets.class).child(OriginatorIdSets.class);
    private final LoadingCache<String, OriginatorIdSet> sets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, OriginatorIdSet>(){

        public OriginatorIdSet load(String key) throws ExecutionException, InterruptedException {
            return MatchOriginatorIdSetHandler.this.loadSets(key);
        }
    });
    private final DataBroker dataBroker;

    public MatchOriginatorIdSetHandler(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    private OriginatorIdSet loadSets(String key) throws ExecutionException, InterruptedException {
        FluentFuture future;
        try (ReadTransaction tr = this.dataBroker.newReadOnlyTransaction();){
            future = tr.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)ORIGINATOR_ID_SETS_IID.child(OriginatorIdSet.class, (Key)new OriginatorIdSetKey(key)));
        }
        return ((Optional)future.get()).orElse(null);
    }

    public boolean matchImportCondition(AfiSafiType afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, OriginatorId originatorId, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.MatchOriginatorIdSetCondition conditions) {
        return this.matchOriginatorCondition((Ipv4Address)routeEntryInfo.getOriginatorId(), originatorId, conditions.getMatchOriginatorIdSetCondition());
    }

    public boolean matchExportCondition(AfiSafiType afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, OriginatorId originatorId, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.odl.bgp._default.policy.rev200120.MatchOriginatorIdSetCondition conditions) {
        return this.matchOriginatorCondition((Ipv4Address)routeEntryInfo.getOriginatorId(), originatorId, conditions.getMatchOriginatorIdSetCondition());
    }

    public OriginatorId getConditionParameter(Attributes attributes) {
        return attributes.getOriginatorId();
    }

    private boolean matchOriginatorCondition(Ipv4Address localOriginatorId, OriginatorId originatorId, MatchOriginatorIdSetCondition condition) {
        MatchSetOptionsRestrictedType matchOption;
        OriginatorIdSet originatorIdSet = (OriginatorIdSet)this.sets.getUnchecked((Object)StringUtils.substringBetween((String)condition.getOriginatorIdSet(), (String)"=\"", (String)"\""));
        if (originatorIdSet == null) {
            return false;
        }
        boolean found = false;
        if (originatorId != null) {
            Ipv4AddressNoZone remOrigin = originatorId.getOriginator();
            if (originatorIdSet.getLocal() != null && localOriginatorId.equals((Object)remOrigin)) {
                found = true;
            }
            if (!found && originatorIdSet.getOriginatorId() != null) {
                found = originatorIdSet.getOriginatorId().contains(remOrigin);
            }
        }
        return (matchOption = condition.getMatchSetOptions()).equals((Object)MatchSetOptionsRestrictedType.ANY) && found || matchOption.equals((Object)MatchSetOptionsRestrictedType.INVERT) && !found;
    }
}

