/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import com.google.common.util.concurrent.FluentFuture;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Before;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.AbstractStatementRegistryTest;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.StatementRegistry;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.StatementRegistryProvider;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.StatementActivator;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.OpenconfigRoutingPolicyData;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.PolicyDefinitions;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.PolicyDefinition;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.PolicyDefinitionKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.Statements;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.statements.Statement;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;

public class AbstractStatementRegistryConsumerTest
extends AbstractStatementRegistryTest {
    protected final StatementRegistry statementRegistry = new StatementRegistry();
    private StatementActivator activator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.activator = new StatementActivator(this.getDataBroker());
        this.activator.start((StatementRegistryProvider)this.statementRegistry);
    }

    @After
    public void tearDown() throws Exception {
        this.activator.stop();
    }

    protected List<Statement> loadStatement(String policyName) throws ExecutionException, InterruptedException {
        FluentFuture future;
        try (ReadTransaction rt = this.getDataBroker().newReadOnlyTransaction();){
            future = rt.read(LogicalDatastoreType.CONFIGURATION, InstanceIdentifier.builderOfInherited(OpenconfigRoutingPolicyData.class, RoutingPolicy.class).build().child(PolicyDefinitions.class).child(PolicyDefinition.class, (Key)new PolicyDefinitionKey(policyName)).child(Statements.class));
        }
        return ((Statements)((Optional)future.get()).orElseThrow()).getStatement();
    }
}

