/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.Collections;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.LocalPrefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.MultiExitDiscBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.OriginatorIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.BgpOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.ClusterIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class ImportAttributeTestUtil {
    static final AsNumber AS = new AsNumber(Uint32.valueOf((int)65));

    private ImportAttributeTestUtil() {
    }

    public static Attributes createInput() {
        AttributesBuilder attBuilder = new AttributesBuilder();
        attBuilder.setLocalPref(new LocalPrefBuilder().setPref(Uint32.valueOf((int)100)).build());
        attBuilder.setClusterId(new ClusterIdBuilder().setCluster(Collections.singletonList(new ClusterIdentifier("40.40.40.40"))).build());
        attBuilder.setCNextHop((CNextHop)ImportAttributeTestUtil.createNexHop());
        attBuilder.setOriginatorId(new OriginatorIdBuilder().setOriginator(new Ipv4AddressNoZone("41.41.41.41")).build());
        attBuilder.setOrigin(ImportAttributeTestUtil.createOrigin());
        attBuilder.setAsPath(new AsPathBuilder().build());
        attBuilder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Uint32.ZERO).build());
        return attBuilder.build();
    }

    public static Attributes createOutput() {
        AttributesBuilder attBuilder = new AttributesBuilder();
        attBuilder.setCNextHop((CNextHop)ImportAttributeTestUtil.createNexHop());
        attBuilder.setOrigin(ImportAttributeTestUtil.createOrigin());
        attBuilder.setAsPath(new AsPathBuilder().setSegments(Collections.singletonList(new SegmentsBuilder().setAsSequence(Collections.singletonList(AS)).build())).build());
        return attBuilder.build();
    }

    private static Origin createOrigin() {
        return new OriginBuilder().setValue(BgpOrigin.Igp).build();
    }

    private static Ipv4NextHopCase createNexHop() {
        return new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4AddressNoZone("199.20.160.41")).build()).build();
    }
}

