/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.impl.PolicyRIBBaseParametersImpl;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.RouteAttributeContainer;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractStatementRegistryConsumerTest;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.IPV4UNICAST;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.statements.Statement;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.PeerId;

public class MatchBgpNeighborSetTest
extends AbstractStatementRegistryConsumerTest {
    @Mock
    private BGPRouteEntryExportParameters exportParameters;
    private List<Statement> basicStatements;
    private PolicyRIBBaseParametersImpl baseAttributes;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.basicStatements = this.loadStatement("bgp-neighbor-statements-test");
        this.baseAttributes = new PolicyRIBBaseParametersImpl(8L, IPV4, CLUSTER);
    }

    @Test
    public void testMatchFromBgpNeighborAny() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("reject-from-neighbor-test")).findFirst().orElseThrow();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://42.42.42.42")).when((Object)this.exportParameters)).getFromPeerId();
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://127.0.0.1")).when((Object)this.exportParameters)).getFromPeerId();
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
    }

    @Test
    public void testMatchFromBgpNeighborInvert() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("reject-from-neighbor-invert-test")).findFirst().orElseThrow();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://42.42.42.42")).when((Object)this.exportParameters)).getFromPeerId();
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://127.0.0.1")).when((Object)this.exportParameters)).getFromPeerId();
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
    }

    @Test
    public void testMatchToBgpNeighborAny() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("reject-to-neighbor-test")).findFirst().orElseThrow();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://127.0.0.2")).when((Object)this.exportParameters)).getFromPeerId();
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://42.42.42.42")).when((Object)this.exportParameters)).getToPeerId();
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://127.0.0.1")).when((Object)this.exportParameters)).getToPeerId();
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
    }

    @Test
    public void testMatchToBgpNeighborInvert() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("reject-to-neighbor-invert-test")).findFirst().orElseThrow();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().build());
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://127.0.0.2")).when((Object)this.exportParameters)).getFromPeerId();
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://42.42.42.42")).when((Object)this.exportParameters)).getToPeerId();
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
        ((BGPRouteEntryExportParameters)Mockito.doReturn((Object)new PeerId("bgp://127.0.0.1")).when((Object)this.exportParameters)).getToPeerId();
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
    }
}

