/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.impl.PolicyRIBBaseParametersImpl;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.registry.RouteAttributeContainer;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.AbstractStatementRegistryConsumerTest;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.IPV4UNICAST;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.policy.definitions.policy.definition.statements.Statement;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.as._4.route.target.extended.community.grouping.As4RouteTargetExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.as._4.route.target.extended.community.grouping.As4RouteTargetExtendedCommunityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.as._4.spec.common.As4SpecificCommon;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.as._4.spec.common.As4SpecificCommonBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.extended.community.extended.community.As4RouteTargetExtendedCommunityCaseBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class VpnNonMemberHandlerTest
extends AbstractStatementRegistryConsumerTest {
    private static final As4SpecificCommon AS_COMMON = new As4SpecificCommonBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)20))).setLocalAdministrator(Uint16.valueOf((int)100)).build();
    private static final As4RouteTargetExtendedCommunity RT = new As4RouteTargetExtendedCommunityBuilder().setAs4SpecificCommon(AS_COMMON).build();
    @Mock
    private BGPRouteEntryExportParameters exportParameters;
    private List<Statement> basicStatements;
    private PolicyRIBBaseParametersImpl baseAttributes;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.basicStatements = this.loadStatement("vpn-non-member-test");
        this.baseAttributes = new PolicyRIBBaseParametersImpl(8L, IPV4, CLUSTER);
    }

    @Test
    public void testExtComAny() {
        Statement statement = this.basicStatements.stream().filter(st -> st.getName().equals("vpn-non-member-test")).findFirst().orElseThrow();
        RouteAttributeContainer attributeContainer = RouteAttributeContainer.routeAttributeContainerFalse((Attributes)new AttributesBuilder().setExtendedCommunities(List.of(new ExtendedCommunitiesBuilder().setExtendedCommunity((ExtendedCommunity)new As4RouteTargetExtendedCommunityCaseBuilder().setAs4RouteTargetExtendedCommunity(RT).build()).build())).build());
        ((BGPRouteEntryExportParameters)Mockito.doReturn(List.of(RT)).when((Object)this.exportParameters)).getMemberships();
        RouteAttributeContainer result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNotNull((Object)result.getAttributes());
        ((BGPRouteEntryExportParameters)Mockito.doReturn(List.of()).when((Object)this.exportParameters)).getMemberships();
        result = this.statementRegistry.applyExportStatement((RouteEntryBaseAttributes)this.baseAttributes, (AfiSafiType)IPV4UNICAST.VALUE, this.exportParameters, attributeContainer, statement);
        Assert.assertNull((Object)result.getAttributes());
    }
}

