/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement.conditions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.RouteEntryBaseAttributes;
import org.opendaylight.protocol.bgp.openconfig.routing.policy.spi.policy.condition.BgpConditionsPolicy;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryExportParameters;
import org.opendaylight.protocol.bgp.rib.spi.policy.BGPRouteEntryImportParameters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.DefinedSets1;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.bgp.match.conditions.MatchAsPathSet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.BgpDefinedSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.AsPathSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.as.path.sets.AsPathSet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.as.path.sets.AsPathSetKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.policy.types.rev151009.MatchSetOptionsType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.OpenconfigRoutingPolicyData;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AsPathSegment;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;

public final class MatchAsPathSetHandler
implements BgpConditionsPolicy<MatchAsPathSet, AsPath> {
    private static final InstanceIdentifier<AsPathSets> AS_PATHS_SETS_IID = InstanceIdentifier.builderOfInherited(OpenconfigRoutingPolicyData.class, RoutingPolicy.class).build().child(DefinedSets.class).augmentation(DefinedSets1.class).child(BgpDefinedSets.class).child(AsPathSets.class);
    private final DataBroker dataBroker;
    private final LoadingCache<String, AsPathSet> sets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AsPathSet>(){

        public AsPathSet load(String key) throws ExecutionException, InterruptedException {
            return MatchAsPathSetHandler.this.loadSets(key);
        }
    });

    public MatchAsPathSetHandler(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
    }

    private AsPathSet loadSets(String key) throws ExecutionException, InterruptedException {
        FluentFuture future;
        try (ReadTransaction tr = this.dataBroker.newReadOnlyTransaction();){
            future = tr.read(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)AS_PATHS_SETS_IID.child(AsPathSet.class, (Key)new AsPathSetKey(key)));
        }
        return ((Optional)future.get()).orElse(null);
    }

    public boolean matchImportCondition(AfiSafiType afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryImportParameters routeEntryImportParameters, AsPath asPath, MatchAsPathSet conditions) {
        return this.matchAsPathSetCondition(asPath, conditions.getAsPathSet(), conditions.getMatchSetOptions());
    }

    public boolean matchExportCondition(AfiSafiType afiSafi, RouteEntryBaseAttributes routeEntryInfo, BGPRouteEntryExportParameters routeEntryExportParameters, AsPath asPath, MatchAsPathSet conditions) {
        return this.matchAsPathSetCondition(asPath, conditions.getAsPathSet(), conditions.getMatchSetOptions());
    }

    public AsPath getConditionParameter(Attributes attributes) {
        return attributes.getAsPath();
    }

    private boolean matchAsPathSetCondition(AsPath asPath, String asPathSetName, MatchSetOptionsType matchSetOptions) {
        if (asPath == null) {
            return false;
        }
        AsPathSet asPathSetFilter = (AsPathSet)this.sets.getUnchecked((Object)StringUtils.substringBetween((String)asPathSetName, (String)"=\"", (String)"\""));
        List segments = asPath.getSegments();
        if (asPathSetFilter == null || segments == null) {
            return false;
        }
        List l1 = segments.stream().map(AsPathSegment::getAsSequence).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        List l2 = segments.stream().map(AsPathSegment::getAsSet).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        List allAs = Stream.of(l1, l2).flatMap(Collection::stream).collect(Collectors.toList());
        Set asPathSetFilterList = asPathSetFilter.getAsPathSetMember();
        if (matchSetOptions.equals((Object)MatchSetOptionsType.ALL)) {
            return allAs.containsAll(asPathSetFilterList) && asPathSetFilterList.containsAll(allAs);
        }
        boolean noneInCommon = Collections.disjoint(allAs, asPathSetFilterList);
        if (matchSetOptions.equals((Object)MatchSetOptionsType.ANY)) {
            return !noneInCommon;
        }
        return noneInCommon;
    }
}

