/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.routing.policy.statement;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.FluentFuture;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.DefinedSets1;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.BgpDefinedSets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ExtCommunitySets;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ext.community.sets.ExtCommunitySet;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ext.community.sets.ExtCommunitySetKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.policy.rev151009.routing.policy.defined.sets.bgp.defined.sets.ext.community.sets.ext.community.set.ExtCommunityMember;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.OpenconfigRoutingPolicyData;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.routing.policy.DefinedSets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev200120.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;

public class AbstractExtCommunityHandler {
    private static final DataObjectIdentifier<ExtCommunitySets> EXT_COMMUNITY_SETS_IID = DataObjectIdentifier.builderOfInherited(OpenconfigRoutingPolicyData.class, RoutingPolicy.class).child(DefinedSets.class).augmentation(DefinedSets1.class).child(BgpDefinedSets.class).child(ExtCommunitySets.class).build();
    private final DataBroker databroker;
    protected final LoadingCache<String, List<ExtendedCommunities>> extCommunitySets = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<ExtendedCommunities>>(){

        public List<ExtendedCommunities> load(String key) throws ExecutionException, InterruptedException {
            FluentFuture future;
            try (ReadTransaction tr = AbstractExtCommunityHandler.this.databroker.newReadOnlyTransaction();){
                future = tr.read(LogicalDatastoreType.CONFIGURATION, (DataObjectIdentifier)EXT_COMMUNITY_SETS_IID.toBuilder().child(ExtCommunitySet.class, (Key)new ExtCommunitySetKey(key)).build());
            }
            return ((Optional)future.get()).map(sets -> sets.nonnullExtCommunityMember().stream().map(AbstractExtCommunityHandler::toExtendedCommunities).collect(Collectors.toList())).orElse(List.of());
        }
    });

    public AbstractExtCommunityHandler(DataBroker databroker) {
        this.databroker = Objects.requireNonNull(databroker);
    }

    private static ExtendedCommunities toExtendedCommunities(ExtCommunityMember ge) {
        return new ExtendedCommunitiesBuilder().setExtendedCommunity(ge.getExtendedCommunity()).setTransitive(ge.getTransitive()).build();
    }
}

