/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.protocol.bgp.openconfig.spi.BGPTableTypeRegistryProvider;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.AbstractRegistration;

public final class SimpleBGPTableTypeRegistryProvider
implements BGPTableTypeRegistryProvider {
    @GuardedBy(value="this")
    private final BiMap<BgpTableType, Class<? extends AfiSafiType>> tableTypes = HashBiMap.create();
    @GuardedBy(value="this")
    private final BiMap<TablesKey, Class<? extends AfiSafiType>> tableKeys = HashBiMap.create();

    @Override
    public synchronized AbstractRegistration registerBGPTableType(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi, Class<? extends AfiSafiType> afiSafiType) {
        BgpTableTypeImpl tableType = new BgpTableTypeImpl(afi, safi);
        Class prev = (Class)this.tableTypes.putIfAbsent((Object)tableType, afiSafiType);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"AFI %s SAFI %s is already registered with %s", afi, safi, (Object)prev);
        TablesKey tableKey = new TablesKey(tableType.getAfi(), tableType.getSafi());
        this.tableKeys.put((Object)tableKey, afiSafiType);
        return new AbstractRegistration((BgpTableType)tableType, tableKey){
            final /* synthetic */ BgpTableType val$tableType;
            final /* synthetic */ TablesKey val$tableKey;
            {
                this.val$tableType = bgpTableType;
                this.val$tableKey = tablesKey;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                SimpleBGPTableTypeRegistryProvider simpleBGPTableTypeRegistryProvider = SimpleBGPTableTypeRegistryProvider.this;
                synchronized (simpleBGPTableTypeRegistryProvider) {
                    SimpleBGPTableTypeRegistryProvider.this.tableTypes.remove((Object)this.val$tableType);
                    SimpleBGPTableTypeRegistryProvider.this.tableKeys.remove((Object)this.val$tableKey);
                }
            }
        };
    }

    @Override
    public synchronized Optional<BgpTableType> getTableType(Class<? extends AfiSafiType> afiSafiType) {
        BgpTableType tableType = (BgpTableType)this.tableTypes.inverse().get(afiSafiType);
        return Optional.ofNullable(tableType);
    }

    @Override
    @Nonnull
    public Optional<TablesKey> getTableKey(@Nonnull Class<? extends AfiSafiType> afiSafiType) {
        TablesKey tableKey = (TablesKey)this.tableKeys.inverse().get(afiSafiType);
        return Optional.ofNullable(tableKey);
    }

    @Override
    public synchronized Optional<Class<? extends AfiSafiType>> getAfiSafiType(BgpTableType bgpTableType) {
        Class afiSafi = (Class)this.tableTypes.get((Object)bgpTableType);
        return Optional.ofNullable(afiSafi);
    }

    @Override
    @Nonnull
    public Optional<Class<? extends AfiSafiType>> getAfiSafiType(@Nonnull TablesKey tablesKey) {
        Class afiSafi = (Class)this.tableKeys.get((Object)tablesKey);
        return Optional.ofNullable(afiSafi);
    }
}

