/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.spi;

import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.openconfig.spi.BGPTableTypeRegistryProvider;
import org.opendaylight.protocol.bgp.openconfig.spi.BGPTableTypeRegistryProviderActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleBGPTableTypeRegistryProviderActivator
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleBGPTableTypeRegistryProviderActivator.class);
    private final BGPTableTypeRegistryProvider providerContext;
    private final List<BGPTableTypeRegistryProviderActivator> extensionActivators;

    public SimpleBGPTableTypeRegistryProviderActivator(BGPTableTypeRegistryProvider providerContext, List<BGPTableTypeRegistryProviderActivator> extensionActivators) {
        this.providerContext = Objects.requireNonNull(providerContext);
        this.extensionActivators = Objects.requireNonNull(extensionActivators);
    }

    public void start() {
        LOG.info("Starting {} BGPTableTypeRegistryProviderActivator instances", (Object)this.extensionActivators.size());
        this.extensionActivators.forEach(activator -> activator.startBGPTableTypeRegistryProvider(this.providerContext));
    }

    @Override
    public void close() {
        LOG.info("Stopping {} BGPTableTypeRegistryProviderActivator instances", (Object)this.extensionActivators.size());
        this.extensionActivators.forEach(BGPTableTypeRegistryProviderActivator::stopBGPTableTypeRegistryProvider);
    }
}

