/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.protocol.bgp.openconfig.spi.BGPTableTypeRegistryProvider;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.AbstractRegistration;

public final class SimpleBGPTableTypeRegistryProvider
implements BGPTableTypeRegistryProvider {
    private final @GuardedBy(value={"this"}) BiMap<BgpTableType, Class<? extends AfiSafiType>> tableTypes = HashBiMap.create();
    private final @GuardedBy(value={"this"}) BiMap<TablesKey, Class<? extends AfiSafiType>> tableKeys = HashBiMap.create();

    @Override
    public synchronized AbstractRegistration registerBGPTableType(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi, Class<? extends AfiSafiType> afiSafiType) {
        BgpTableTypeImpl tableType = new BgpTableTypeImpl(afi, safi);
        Class prev = (Class)this.tableTypes.putIfAbsent((Object)tableType, afiSafiType);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"AFI %s SAFI %s is already registered with %s", afi, safi, (Object)prev);
        TablesKey tableKey = new TablesKey(tableType.getAfi(), tableType.getSafi());
        this.tableKeys.put((Object)tableKey, afiSafiType);
        return new AbstractRegistration((BgpTableType)tableType, tableKey){
            final /* synthetic */ BgpTableType val$tableType;
            final /* synthetic */ TablesKey val$tableKey;
            {
                this.val$tableType = bgpTableType;
                this.val$tableKey = tablesKey;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                SimpleBGPTableTypeRegistryProvider simpleBGPTableTypeRegistryProvider = SimpleBGPTableTypeRegistryProvider.this;
                synchronized (simpleBGPTableTypeRegistryProvider) {
                    SimpleBGPTableTypeRegistryProvider.this.tableTypes.remove((Object)this.val$tableType);
                    SimpleBGPTableTypeRegistryProvider.this.tableKeys.remove((Object)this.val$tableKey);
                }
            }
        };
    }

    @Override
    public synchronized Optional<BgpTableType> getTableType(Class<? extends AfiSafiType> afiSafiType) {
        return Optional.ofNullable((BgpTableType)this.tableTypes.inverse().get(afiSafiType));
    }

    @Override
    public Optional<TablesKey> getTableKey(Class<? extends AfiSafiType> afiSafiType) {
        return Optional.ofNullable((TablesKey)this.tableKeys.inverse().get(afiSafiType));
    }

    @Override
    public synchronized Optional<Class<? extends AfiSafiType>> getAfiSafiType(BgpTableType bgpTableType) {
        return Optional.ofNullable((Class)this.tableTypes.get((Object)bgpTableType));
    }

    @Override
    public Optional<Class<? extends AfiSafiType>> getAfiSafiType(TablesKey tablesKey) {
        return Optional.ofNullable((Class)this.tableKeys.get((Object)tablesKey));
    }
}

