/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.spi;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableBiMap;
import java.util.List;
import java.util.ServiceLoader;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bgp.openconfig.spi.AbstractBGPTableTypeRegistryConsumer;
import org.opendaylight.protocol.bgp.openconfig.spi.BGPTableTypeRegistryConsumer;
import org.opendaylight.protocol.bgp.openconfig.spi.BGPTableTypeRegistryProviderActivator;
import org.opendaylight.protocol.bgp.openconfig.spi.SimpleBGPTableTypeRegistryProvider;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yangtools.concepts.Immutable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Singleton
@Beta
@Component(immediate=true, service={BGPTableTypeRegistryConsumer.class})
public final class DefaultBGPTableTypeRegistryConsumer
extends AbstractBGPTableTypeRegistryConsumer
implements Immutable {
    private final @NonNull ImmutableBiMap<BgpTableType, AfiSafiType> tableTypes;
    private final @NonNull ImmutableBiMap<TablesKey, AfiSafiType> tableKeys;

    public DefaultBGPTableTypeRegistryConsumer() {
        this(ServiceLoader.load(BGPTableTypeRegistryProviderActivator.class));
    }

    @Inject
    public DefaultBGPTableTypeRegistryConsumer(Iterable<BGPTableTypeRegistryProviderActivator> activators) {
        SimpleBGPTableTypeRegistryProvider builder = new SimpleBGPTableTypeRegistryProvider();
        for (BGPTableTypeRegistryProviderActivator activator : activators) {
            activator.startBGPTableTypeRegistryProvider(builder);
        }
        this.tableTypes = ImmutableBiMap.copyOf(builder.tableTypes());
        this.tableKeys = ImmutableBiMap.copyOf(builder.tableKeys());
    }

    @Activate
    public DefaultBGPTableTypeRegistryConsumer(@Reference(policyOption=ReferencePolicyOption.GREEDY) List<BGPTableTypeRegistryProviderActivator> activators) {
        this((Iterable<BGPTableTypeRegistryProviderActivator>)activators);
    }

    ImmutableBiMap<BgpTableType, AfiSafiType> tableTypes() {
        return this.tableTypes;
    }

    ImmutableBiMap<TablesKey, AfiSafiType> tableKeys() {
        return this.tableKeys;
    }
}

