/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.bgp.openconfig.spi.AbstractBGPTableTypeRegistryConsumer;
import org.opendaylight.protocol.bgp.openconfig.spi.BGPTableTypeRegistryProvider;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.bgp.types.rev151009.AfiSafiType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev200120.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.concepts.Registration;

@VisibleForTesting
final class SimpleBGPTableTypeRegistryProvider
extends AbstractBGPTableTypeRegistryConsumer
implements BGPTableTypeRegistryProvider,
Mutable {
    private final @NonNull BiMap<BgpTableType, AfiSafiType> tableTypes = HashBiMap.create();
    private final @NonNull BiMap<TablesKey, AfiSafiType> tableKeys = HashBiMap.create();

    SimpleBGPTableTypeRegistryProvider() {
    }

    @Override
    public Registration registerBGPTableType(AddressFamily afi, SubsequentAddressFamily safi, AfiSafiType afiSafiType) {
        BgpTableTypeImpl tableType = new BgpTableTypeImpl(afi, safi);
        AfiSafiType prev = (AfiSafiType)this.tableTypes.putIfAbsent((Object)tableType, (Object)afiSafiType);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"AFI %s SAFI %s is already registered with %s", (Object)afi, (Object)safi, (Object)prev);
        TablesKey tableKey = new TablesKey(afi, safi);
        this.tableKeys.put((Object)tableKey, (Object)afiSafiType);
        return new AbstractRegistration((BgpTableType)tableType, tableKey){
            final /* synthetic */ BgpTableType val$tableType;
            final /* synthetic */ TablesKey val$tableKey;
            {
                this.val$tableType = bgpTableType;
                this.val$tableKey = tablesKey;
            }

            protected void removeRegistration() {
                SimpleBGPTableTypeRegistryProvider.this.tableTypes.remove((Object)this.val$tableType);
                SimpleBGPTableTypeRegistryProvider.this.tableKeys.remove((Object)this.val$tableKey);
            }
        };
    }

    @Override
    BiMap<BgpTableType, AfiSafiType> tableTypes() {
        return this.tableTypes;
    }

    @Override
    BiMap<TablesKey, AfiSafiType> tableKeys() {
        return this.tableKeys;
    }
}

