/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.spi.pojo;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.opendaylight.protocol.bgp.mode.api.PathSelectionMode;
import org.opendaylight.protocol.bgp.openconfig.spi.InstanceConfigurationIdentifier;
import org.opendaylight.protocol.bgp.openconfig.spi.pojo.AbstractInstanceConfiguration;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev130925.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.BgpId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ClusterIdentifier;

public final class BGPRibInstanceConfiguration
extends AbstractInstanceConfiguration {
    private final AsNumber localAs;
    private final BgpId bgpRibId;
    private final ClusterIdentifier clusterId;
    private final List<BgpTableType> tableTypes;
    private final Map<TablesKey, PathSelectionMode> pathSelectionModes;

    public BGPRibInstanceConfiguration(InstanceConfigurationIdentifier identifier, AsNumber localAs, BgpId bgpRibId, ClusterIdentifier clusterId, List<BgpTableType> tableTypes, Map<TablesKey, PathSelectionMode> pathSelectionModes) {
        super(identifier);
        this.pathSelectionModes = pathSelectionModes;
        this.localAs = (AsNumber)Preconditions.checkNotNull((Object)localAs);
        this.bgpRibId = (BgpId)Preconditions.checkNotNull((Object)bgpRibId);
        this.clusterId = clusterId;
        this.tableTypes = (List)Preconditions.checkNotNull(tableTypes);
    }

    public AsNumber getLocalAs() {
        return this.localAs;
    }

    public BgpId getBgpRibId() {
        return this.bgpRibId;
    }

    public Optional<ClusterIdentifier> getClusterId() {
        return Optional.fromNullable((Object)this.clusterId);
    }

    public List<BgpTableType> getTableTypes() {
        return this.tableTypes;
    }

    public Map<TablesKey, PathSelectionMode> getPathSelectionModes() {
        return this.pathSelectionModes;
    }
}

