/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.openconfig.spi.pojo;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import org.opendaylight.protocol.bgp.openconfig.spi.InstanceConfigurationIdentifier;
import org.opendaylight.protocol.bgp.openconfig.spi.pojo.AbstractInstanceConfiguration;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.mp.capabilities.add.path.capability.AddressFamilies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev130925.PeerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324.Rfc2385Key;

public final class BGPPeerInstanceConfiguration
extends AbstractInstanceConfiguration {
    private final IpAddress host;
    private final PortNumber port;
    private final int holdTimer;
    private final PeerRole peerRole;
    private final boolean active;
    private final List<BgpTableType> advertizedTables;
    private final AsNumber asNumber;
    private final Optional<Rfc2385Key> password;
    private final List<AddressFamilies> addPathCapabilities;

    public BGPPeerInstanceConfiguration(InstanceConfigurationIdentifier identifier, IpAddress host, PortNumber port, int holdTimer, PeerRole peerRole, boolean active, List<BgpTableType> advertizedTables, AsNumber asNumber, Optional<Rfc2385Key> password, List<AddressFamilies> addPathCapabilities) {
        super(identifier);
        this.addPathCapabilities = addPathCapabilities;
        this.host = (IpAddress)Preconditions.checkNotNull((Object)host);
        this.port = (PortNumber)Preconditions.checkNotNull((Object)port);
        this.holdTimer = (Integer)Preconditions.checkNotNull((Object)holdTimer);
        this.peerRole = (PeerRole)Preconditions.checkNotNull((Object)peerRole);
        this.active = (Boolean)Preconditions.checkNotNull((Object)active);
        this.advertizedTables = (List)Preconditions.checkNotNull(advertizedTables);
        this.asNumber = (AsNumber)Preconditions.checkNotNull((Object)asNumber);
        this.password = (Optional)Preconditions.checkNotNull(password);
    }

    public IpAddress getHost() {
        return this.host;
    }

    public PortNumber getPort() {
        return this.port;
    }

    public int getHoldTimer() {
        return this.holdTimer;
    }

    public PeerRole getPeerRole() {
        return this.peerRole;
    }

    public boolean isActive() {
        return this.active;
    }

    public List<BgpTableType> getAdvertizedTables() {
        return this.advertizedTables;
    }

    public AsNumber getAsNumber() {
        return this.asNumber;
    }

    public Optional<Rfc2385Key> getPassword() {
        return this.password;
    }

    public List<AddressFamilies> getAddPathCapabilities() {
        return this.addPathCapabilities;
    }
}

