/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

public final class AsNumberUtil {
    private AsNumberUtil() {
        throw new UnsupportedOperationException();
    }

    public static @NonNull AsNumber advertizedAsNumber(Open open) {
        List params = open.getBgpParameters();
        if (params != null) {
            for (BgpParameters p : params) {
                for (OptionalCapabilities oc : p.getOptionalCapabilities()) {
                    if (oc.getCParameters() == null || oc.getCParameters().getAs4BytesCapability() == null) continue;
                    return oc.getCParameters().getAs4BytesCapability().getAsNumber();
                }
            }
        }
        return new AsNumber(Long.valueOf(open.getMyAsNumber().longValue()));
    }

    public static AsNumber extractAS(DataContainerNode<?> dtc, YangInstanceIdentifier.NodeIdentifier nid) {
        NormalizedNode as = NormalizedNodes.findNode(dtc, (YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{nid}).orElse(null);
        if (as != null) {
            return new AsNumber((Long)as.getValue());
        }
        return null;
    }
}

