/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;

public enum BGPError {
    UNSPECIFIC_HEADER_ERROR(1, 0),
    CONNECTION_NOT_SYNC(1, 1),
    BAD_MSG_LENGTH(1, 2),
    BAD_MSG_TYPE(1, 3),
    UNSPECIFIC_OPEN_ERROR(2, 0),
    VERSION_NOT_SUPPORTED(2, 1),
    BAD_PEER_AS(2, 2),
    BAD_BGP_ID(2, 3),
    OPT_PARAM_NOT_SUPPORTED(2, 4),
    HOLD_TIME_NOT_ACC(2, 6),
    UNSPECIFIC_UPDATE_ERROR(3, 0),
    MALFORMED_ATTR_LIST(3, 1),
    WELL_KNOWN_ATTR_NOT_RECOGNIZED(3, 2),
    WELL_KNOWN_ATTR_MISSING(3, 3),
    ATTR_FLAGS_MISSING(3, 4),
    ATTR_LENGTH_ERROR(3, 5),
    ORIGIN_ATTR_NOT_VALID(3, 6),
    NEXT_HOP_NOT_VALID(3, 8),
    OPT_ATTR_ERROR(3, 9),
    NETWORK_NOT_VALID(3, 10),
    AS_PATH_MALFORMED(3, 11),
    HOLD_TIMER_EXPIRED(4, 0),
    FSM_ERROR(5, 0),
    CEASE(6, 0),
    MAX_NUMBER_OF_PREFIXES_REACHED(6, 1),
    ADMINISTRATIVE_SHUTDOWN(6, 2),
    PEER_DECONFIGURED(6, 3),
    ADMINISTRATIVE_RESTART(6, 4),
    CONNECTION_REJECTED(6, 5),
    OTHER_CONFIGURATION_CHANGE(6, 6),
    CONNECTION_COLLISION_RESOLUTION(6, 7),
    OUT_OF_RESOURCES(6, 8),
    UNSUPPORTED_CAPABILITY(2, 7);

    public static final String MANDATORY_ATTR_MISSING_MSG = "Well known mandatory attribute missing: ";
    private static final ImmutableMap<BGPErrorIdentifier, BGPError> VALUE_MAP;
    private final BGPErrorIdentifier errorId;

    private BGPError(short code, short subcode) {
        this.errorId = new BGPErrorIdentifier(code, subcode);
    }

    public static BGPError forValue(int code, int subcode) {
        BGPError e = (BGPError)((Object)VALUE_MAP.get((Object)new BGPErrorIdentifier((short)code, (short)subcode)));
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (String)"BGP Error code %s and subcode %s not recognized.", (int)code, (int)subcode);
        return e;
    }

    public short getCode() {
        return this.errorId.code;
    }

    public short getSubcode() {
        return this.errorId.subcode;
    }

    private BGPErrorIdentifier getErrorIdentifier() {
        return this.errorId;
    }

    static {
        VALUE_MAP = Maps.uniqueIndex(Arrays.asList(BGPError.values()), BGPError::getErrorIdentifier);
    }

    private static class BGPErrorIdentifier
    implements Serializable {
        private static final long serialVersionUID = 5722575354944165734L;
        final short code;
        final short subcode;

        BGPErrorIdentifier(short code, short subcode) {
            this.code = code;
            this.subcode = subcode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.code;
            result = 31 * result + this.subcode;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BGPErrorIdentifier other = (BGPErrorIdentifier)obj;
            return this.code == other.code && this.subcode == other.subcode;
        }

        public String toString() {
            return "type " + this.code + " value " + this.subcode;
        }
    }
}

