/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.c.parameters.BgpExtendedMessageCapabilityBuilder;

public final class BgpExtendedMessageUtil {
    public static final CParameters EXTENDED_MESSAGE_CAPABILITY = new CParametersBuilder().setBgpExtendedMessageCapability(new BgpExtendedMessageCapabilityBuilder().build()).build();

    private BgpExtendedMessageUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean advertizedBgpExtendedMessageCapability(Open open) {
        List params = open.getBgpParameters();
        if (params != null) {
            for (BgpParameters p : params) {
                for (OptionalCapabilities oc : p.getOptionalCapabilities()) {
                    if (oc.getCParameters() == null || oc.getCParameters().getBgpExtendedMessageCapability() == null) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

