/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.GracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.LlGracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.graceful.restart.capability.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;

public final class GracefulRestartUtil {
    public static final @NonNull GracefulRestartCapability EMPTY_GR_CAPABILITY = new GracefulRestartCapabilityBuilder().setTables((List<Tables>)ImmutableList.of()).setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.FALSE)).setRestartTime(0).build();
    public static final @NonNull LlGracefulRestartCapability EMPTY_LLGR_CAPABILITY = new LlGracefulRestartCapabilityBuilder().setTables((List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.ll.graceful.restart.capability.Tables>)ImmutableList.of()).build();

    private GracefulRestartUtil() {
    }

    @Beta
    public static @NonNull Tables gracefulRestartTable(@NonNull Class<? extends AddressFamily> afi, @NonNull Class<? extends SubsequentAddressFamily> safi, boolean forwardingState) {
        return GracefulRestartUtil.gracefulRestartTable(new TablesKey(afi, safi), forwardingState);
    }

    @Beta
    public static @NonNull Tables gracefulRestartTable(@NonNull TablesKey table, boolean forwardingState) {
        return new TablesBuilder().withKey(table).setAfiFlags(new Tables.AfiFlags(forwardingState)).build();
    }

    @Beta
    public static @NonNull CParameters gracefulRestartCapability(List<Tables> tables, int restartTime, boolean localRestarting) {
        return new CParametersBuilder().addAugmentation(CParameters1.class, new CParameters1Builder().setGracefulRestartCapability(new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(localRestarting)).setRestartTime(restartTime).setTables(tables).build()).build()).build();
    }
}

