/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.Notify;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.NotifyMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NotifyBuilder
implements Builder<Notify> {
    private byte[] _data;
    private Short _errorCode;
    private Short _errorSubcode;
    Map<Class<? extends Augmentation<Notify>>, Augmentation<Notify>> augmentation = Collections.emptyMap();

    public NotifyBuilder() {
    }

    public NotifyBuilder(NotifyMessage arg) {
        this._errorCode = arg.getErrorCode();
        this._errorSubcode = arg.getErrorSubcode();
        this._data = arg.getData();
    }

    public NotifyBuilder(Notify base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Notify>>, Augmentation<Notify>>(aug);
        }
        this._data = base.getData();
        this._errorCode = base.getErrorCode();
        this._errorSubcode = base.getErrorSubcode();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NotifyMessage) {
            this._errorCode = ((NotifyMessage)arg).getErrorCode();
            this._errorSubcode = ((NotifyMessage)arg).getErrorSubcode();
            this._data = ((NotifyMessage)arg).getData();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.NotifyMessage]");
    }

    public byte[] getData() {
        return this._data == null ? null : (byte[])this._data.clone();
    }

    public Short getErrorCode() {
        return this._errorCode;
    }

    public Short getErrorSubcode() {
        return this._errorSubcode;
    }

    public <E$$ extends Augmentation<Notify>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NotifyBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    private static void checkErrorCodeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public NotifyBuilder setErrorCode(Short value) {
        if (value != null) {
            NotifyBuilder.checkErrorCodeRange(value);
        }
        this._errorCode = value;
        return this;
    }

    private static void checkErrorSubcodeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public NotifyBuilder setErrorSubcode(Short value) {
        if (value != null) {
            NotifyBuilder.checkErrorSubcodeRange(value);
        }
        this._errorSubcode = value;
        return this;
    }

    public NotifyBuilder addAugmentation(Class<? extends Augmentation<Notify>> augmentationType, Augmentation<Notify> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Notify>>, Augmentation<Notify>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NotifyBuilder removeAugmentation(Class<? extends Augmentation<Notify>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Notify build() {
        return new NotifyImpl(this);
    }

    private static final class NotifyImpl
    extends AbstractAugmentable<Notify>
    implements Notify {
        private final byte[] _data;
        private final Short _errorCode;
        private final Short _errorSubcode;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NotifyImpl(NotifyBuilder base) {
            super(base.augmentation);
            this._data = base.getData();
            this._errorCode = base.getErrorCode();
            this._errorSubcode = base.getErrorSubcode();
        }

        @Override
        public byte[] getData() {
            return this._data == null ? null : (byte[])this._data.clone();
        }

        @Override
        public Short getErrorCode() {
            return this._errorCode;
        }

        @Override
        public Short getErrorSubcode() {
            return this._errorSubcode;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._errorCode);
            result = 31 * result + Objects.hashCode(this._errorSubcode);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Notify.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Notify other = (Notify)obj;
            if (!Arrays.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._errorCode, other.getErrorCode())) {
                return false;
            }
            if (!Objects.equals(this._errorSubcode, other.getErrorSubcode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NotifyImpl otherImpl = (NotifyImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Notify");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_data", (byte[])this._data);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorCode", (Object)this._errorCode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorSubcode", (Object)this._errorSubcode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

