/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.BgpAggregator;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AggregatorBuilder
implements Builder<Aggregator> {
    private AsNumber _asNumber;
    private Ipv4Address _networkAddress;
    Map<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>> augmentation = Collections.emptyMap();

    public AggregatorBuilder() {
    }

    public AggregatorBuilder(BgpAggregator arg) {
        this._asNumber = arg.getAsNumber();
        this._networkAddress = arg.getNetworkAddress();
    }

    public AggregatorBuilder(Aggregator base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>>(aug);
        }
        this._asNumber = base.getAsNumber();
        this._networkAddress = base.getNetworkAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpAggregator) {
            this._asNumber = ((BgpAggregator)arg).getAsNumber();
            this._networkAddress = ((BgpAggregator)arg).getNetworkAddress();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.BgpAggregator]");
    }

    public AsNumber getAsNumber() {
        return this._asNumber;
    }

    public Ipv4Address getNetworkAddress() {
        return this._networkAddress;
    }

    public <E$$ extends Augmentation<Aggregator>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AggregatorBuilder setAsNumber(AsNumber value) {
        this._asNumber = value;
        return this;
    }

    public AggregatorBuilder setNetworkAddress(Ipv4Address value) {
        this._networkAddress = value;
        return this;
    }

    public AggregatorBuilder addAugmentation(Class<? extends Augmentation<Aggregator>> augmentationType, Augmentation<Aggregator> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Aggregator>>, Augmentation<Aggregator>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AggregatorBuilder removeAugmentation(Class<? extends Augmentation<Aggregator>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Aggregator build() {
        return new AggregatorImpl(this);
    }

    private static final class AggregatorImpl
    extends AbstractAugmentable<Aggregator>
    implements Aggregator {
        private final AsNumber _asNumber;
        private final Ipv4Address _networkAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AggregatorImpl(AggregatorBuilder base) {
            super(base.augmentation);
            this._asNumber = base.getAsNumber();
            this._networkAddress = base.getNetworkAddress();
        }

        public AsNumber getAsNumber() {
            return this._asNumber;
        }

        public Ipv4Address getNetworkAddress() {
            return this._networkAddress;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._asNumber);
            result = 31 * result + Objects.hashCode(this._networkAddress);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Aggregator.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Aggregator other = (Aggregator)obj;
            if (!Objects.equals(this._asNumber, other.getAsNumber())) {
                return false;
            }
            if (!Objects.equals(this._networkAddress, other.getNetworkAddress())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AggregatorImpl otherImpl = (AggregatorImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Aggregator");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_asNumber", (Object)this._asNumber);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_networkAddress", (Object)this._networkAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

