/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.Community;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CommunitiesBuilder
implements Builder<Communities> {
    private AsNumber _asNumber;
    private Integer _semantics;
    Map<Class<? extends Augmentation<Communities>>, Augmentation<Communities>> augmentation = Collections.emptyMap();

    public CommunitiesBuilder() {
    }

    public CommunitiesBuilder(Community arg) {
        this._asNumber = arg.getAsNumber();
        this._semantics = arg.getSemantics();
    }

    public CommunitiesBuilder(Communities base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Communities>>, Augmentation<Communities>>(aug);
        }
        this._asNumber = base.getAsNumber();
        this._semantics = base.getSemantics();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Community) {
            this._asNumber = ((Community)arg).getAsNumber();
            this._semantics = ((Community)arg).getSemantics();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.Community]");
    }

    public AsNumber getAsNumber() {
        return this._asNumber;
    }

    public Integer getSemantics() {
        return this._semantics;
    }

    public <E$$ extends Augmentation<Communities>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public CommunitiesBuilder setAsNumber(AsNumber value) {
        this._asNumber = value;
        return this;
    }

    private static void checkSemanticsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public CommunitiesBuilder setSemantics(Integer value) {
        if (value != null) {
            CommunitiesBuilder.checkSemanticsRange(value);
        }
        this._semantics = value;
        return this;
    }

    public CommunitiesBuilder addAugmentation(Class<? extends Augmentation<Communities>> augmentationType, Augmentation<Communities> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Communities>>, Augmentation<Communities>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CommunitiesBuilder removeAugmentation(Class<? extends Augmentation<Communities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Communities build() {
        return new CommunitiesImpl(this);
    }

    private static final class CommunitiesImpl
    extends AbstractAugmentable<Communities>
    implements Communities {
        private final AsNumber _asNumber;
        private final Integer _semantics;
        private int hash = 0;
        private volatile boolean hashValid = false;

        CommunitiesImpl(CommunitiesBuilder base) {
            super(base.augmentation);
            this._asNumber = base.getAsNumber();
            this._semantics = base.getSemantics();
        }

        public AsNumber getAsNumber() {
            return this._asNumber;
        }

        public Integer getSemantics() {
            return this._semantics;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._asNumber);
            result = 31 * result + Objects.hashCode(this._semantics);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Communities.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Communities other = (Communities)obj;
            if (!Objects.equals(this._asNumber, other.getAsNumber())) {
                return false;
            }
            if (!Objects.equals(this._semantics, other.getSemantics())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CommunitiesImpl otherImpl = (CommunitiesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Communities");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_asNumber", (Object)this._asNumber);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_semantics", (Object)this._semantics);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

